/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.response;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zkoss.zats.mimic.Client;
import org.zkoss.zats.mimic.DesktopAgent;
import org.zkoss.zats.mimic.Resource;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.DesktopCtrl;
import org.zkoss.zats.mimic.impl.LayoutResponseHandler;
import org.zkoss.zats.mimic.impl.UpdateResponseHandler;
import org.zkoss.zats.mimic.impl.au.AuUtility;
import org.zkoss.zk.au.AuResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadHandler
implements UpdateResponseHandler,
LayoutResponseHandler {
    public static final String REGISTER_KEY = "download";
    private static final Logger logger = Logger.getLogger(DownloadHandler.class.getName());

    @Override
    public void process(DesktopAgent desktop, Map<String, Object> jsonObject) {
        ((DesktopCtrl)((Object)desktop)).setDownloadable(null);
        List<AuResponse> resp = AuUtility.convertToResponses(jsonObject);
        HashMap<String, AuResponse> map = new HashMap<String, AuResponse>();
        for (AuResponse r : resp) {
            map.put(r.getCommand(), r);
        }
        AuResponse download = (AuResponse)map.get(REGISTER_KEY);
        if (download != null) {
            Object[] data = download.getRawData();
            String path = data[0].toString().replaceAll("\\\\", "");
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("download event: " + path);
            }
            DownloadableImpl downloadable = new DownloadableImpl(desktop, path);
            ((DesktopCtrl)((Object)desktop)).setDownloadable(downloadable);
        }
    }

    @Override
    public void process(DesktopAgent desktopAgent, String response) {
        Map<String, Object> map = AuUtility.parseAuResponseFromLayout(response = response.replaceAll("[&]", "&amp;"));
        if (map != null) {
            this.process(desktopAgent, map);
        }
    }

    private static class DownloadableImpl
    implements Resource {
        private DesktopAgent desktop;
        private String path;

        public DownloadableImpl(DesktopAgent desktop, String path) {
            this.desktop = desktop;
            this.path = path;
        }

        public String getName() {
            return this.path.substring(this.path.lastIndexOf("/") + 1);
        }

        public InputStream getInputStream() throws IOException {
            Client client = this.desktop.getClient();
            ClientCtrl cc = (ClientCtrl)((Object)client);
            return cc.openConnection(this.path);
        }
    }
}

