/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.impl.response;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.zats.mimic.Client;
import org.zkoss.zats.mimic.DesktopAgent;
import org.zkoss.zats.mimic.EchoEventMode;
import org.zkoss.zats.mimic.impl.ClientCtrl;
import org.zkoss.zats.mimic.impl.LayoutResponseHandler;
import org.zkoss.zats.mimic.impl.UpdateResponseHandler;
import org.zkoss.zats.mimic.impl.au.AuUtility;
import org.zkoss.zk.au.AuResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EchoEventHandler
implements UpdateResponseHandler,
LayoutResponseHandler {
    public static final String REGISTER_KEY = "echo";
    private static final String REQUEST_ECHO_EVENT = "echo";
    private static final String RESPONSE_ECHO_EVENT = "echo2";

    @Override
    public void process(DesktopAgent desktop, Map<String, Object> jsonObject) {
        List<AuResponse> responses = AuUtility.convertToResponses(jsonObject);
        for (AuResponse resp : responses) {
            if (!RESPONSE_ECHO_EVENT.equals(resp.getCommand())) continue;
            Object[] rawData = resp.getRawData();
            String uuid = this.parseUuid(rawData[0]);
            ArrayList<Object> replyData = new ArrayList<Object>();
            int i = 1;
            while (i < rawData.length) {
                replyData.add(rawData[i]);
                ++i;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("", replyData);
            Client client = desktop.getClient();
            if (client.getEchoEventMode() == EchoEventMode.PIGGYBACK) {
                ((ClientCtrl)((Object)client)).postPiggyback(desktop.getId(), uuid, "echo", data, true);
                continue;
            }
            ((ClientCtrl)((Object)client)).postUpdate(desktop.getId(), uuid, "echo", data, true);
        }
    }

    protected String parseUuid(Object object) {
        return object.toString();
    }

    @Override
    public void process(DesktopAgent desktopAgent, String response) {
        Map<String, Object> map = AuUtility.parseAuResponseFromLayout(response = response.replaceAll("[&]", "&amp;"));
        if (map != null) {
            this.process(desktopAgent, map);
        }
    }
}

