/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.mimic.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.zats.common.json.JSONObject;
import org.zkoss.zats.mimic.AgentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuData {
    private String eventName;
    private Map<String, Object> data = new HashMap<String, Object>();

    public AuData(String eventName) {
        if (eventName == null || eventName.length() <= 0) {
            throw new AgentException("event name can't be null or empty");
        }
        this.eventName = eventName;
    }

    public AuData setData(String key, Object value) {
        if (key == null) {
            throw new AgentException("key can't be null.");
        }
        this.checkType(value);
        this.data.put(key, value);
        return this;
    }

    public AuData setData(String key, Object[] values) {
        if (key == null) {
            throw new AgentException("key can't be null.");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            this.checkType(value);
            list.add(value);
            ++n2;
        }
        this.data.put(key, list);
        return this;
    }

    private void checkType(Object object) {
        if (!(object instanceof JSONObject || object instanceof String || object instanceof Number || object instanceof Boolean || object == null)) {
            throw new AgentException("object type should be org.zkoss.zats.common.json.JSONObject, java.lang.String, java.lang.Number, java.lang.Boolean or null.");
        }
    }

    public String getName() {
        return this.eventName;
    }

    public Map<String, Object> getData() {
        return this.data;
    }
}

