/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class SearchPredicate
implements HighlightPredicate {
    public static final int ALL = -1;
    public static final String MATCH_ALL = ".*";
    private int highlightColumn;
    private int highlightRow;
    private Pattern pattern;

    public SearchPredicate(Pattern pattern) {
        this(pattern, -1, -1);
    }

    public SearchPredicate(Pattern pattern, int column) {
        this(pattern, -1, column);
    }

    public SearchPredicate(Pattern pattern, int row, int column) {
        this.pattern = pattern;
        this.highlightColumn = column;
        this.highlightRow = row;
    }

    public SearchPredicate(String regex) {
        this(regex, -1, -1);
    }

    public SearchPredicate(String regex, int column) {
        this(regex, -1, column);
    }

    public SearchPredicate(String regex, int row, int column) {
        this(regex != null && regex.length() > 0 ? Pattern.compile(regex) : null, row, column);
    }

    public int getHighlightColumn() {
        return this.highlightColumn;
    }

    public int getHighlightRow() {
        return this.highlightRow;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
        if (this.isHighlightCandidate(renderer, adapter)) {
            return this.test(renderer, adapter);
        }
        return false;
    }

    private boolean test(Component renderer, ComponentAdapter adapter) {
        int columnToTest = adapter.viewToModel(adapter.column);
        String value = adapter.getString(columnToTest);
        if (value == null || value.length() == 0) {
            return false;
        }
        return this.pattern.matcher(value).find();
    }

    private boolean isHighlightCandidate(Component renderer, ComponentAdapter adapter) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.highlightRow >= 0 && adapter.row != this.highlightRow) {
            return false;
        }
        return this.highlightColumn < 0 || this.highlightColumn == adapter.viewToModel(adapter.column);
    }

    private boolean isEnabled() {
        Pattern pattern = this.getPattern();
        return pattern != null && !MATCH_ALL.equals(pattern.pattern());
    }
}

