/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.icon.SortArrowIcon;
import org.jdesktop.swingx.plaf.ColumnHeaderRendererAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.table.LabelProperties;

public class ColumnHeaderRenderer
extends JComponent
implements TableCellRenderer,
UIResource {
    private static final Logger LOG = Logger.getLogger(ColumnHeaderRenderer.class.getName());
    public static final String UP_ICON_KEY = "ColumnHeaderRenderer.upIcon";
    public static final String DOWN_ICON_KEY = "ColumnHeaderRenderer.downIcon";
    public static final String VISTA_BORDER_HACK = "ColumnHeaderRenderer.vistaBorderHack";
    public static final String METAL_BORDER_HACK = "ColumnHeaderRenderer.metalBorderHack";
    private static TableCellRenderer sharedInstance;
    private static Icon defaultDownIcon;
    private static Icon defaultUpIcon;
    private Icon downIcon = defaultDownIcon;
    private Icon upIcon = defaultUpIcon;
    private IconBorder iconBorder = new IconBorder();
    private boolean antiAliasedText = false;
    private TableCellRenderer delegateRenderer;
    private LabelProperties label = new LabelProperties();

    public static TableCellRenderer getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ColumnHeaderRenderer();
        }
        return sharedInstance;
    }

    public static ColumnHeaderRenderer createColumnHeaderRenderer() {
        return new ColumnHeaderRenderer();
    }

    public ColumnHeaderRenderer() {
        this.initDelegate();
        this.updateIconUI();
    }

    public ColumnHeaderRenderer(JTableHeader header) {
        this.updateUI(header);
    }

    private void initDelegate() {
        JTableHeader header = null;
        if (header == null) {
            header = new JTableHeader();
        }
        this.delegateRenderer = header.getDefaultRenderer();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        Component comp = this.configureDelegate(table, value, isSelected, hasFocus, rowIndex, columnIndex);
        if (table instanceof JXTable && comp instanceof JComponent) {
            this.hackBorder((JComponent)comp);
            SortOrder sortOrder = ((JXTable)table).getSortOrder(columnIndex);
            if (sortOrder.isSorted()) {
                this.iconBorder.setIcon(sortOrder.isAscending() ? this.upIcon : this.downIcon);
                Border origBorder = ((JComponent)comp).getBorder();
                CompoundBorder border = new CompoundBorder(origBorder, this.iconBorder);
                ((JComponent)comp).setBorder(border);
            }
        }
        this.adjustComponentOrientation(comp);
        return comp;
    }

    private void hackBorder(JComponent component) {
        if (this.hackBorder(component, VISTA_BORDER_HACK)) {
            return;
        }
        this.hackBorder(component, METAL_BORDER_HACK);
    }

    private boolean hackBorder(JComponent component, Object key) {
        Border hackBorder = UIManager.getBorder(key);
        if (hackBorder == null) {
            return false;
        }
        component.setBorder(hackBorder);
        return true;
    }

    protected void adjustComponentOrientation(Component stamp) {
        if (stamp.getComponentOrientation().equals(this.getComponentOrientation())) {
            return;
        }
        stamp.applyComponentOrientation(this.getComponentOrientation());
    }

    private Component configureDelegate(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        Component comp = this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, columnIndex);
        this.applyLabelProperties(comp);
        return comp;
    }

    private void applyLabelProperties(Component delegateRendererComponent) {
        if (delegateRendererComponent instanceof JLabel) {
            this.label.applyPropertiesTo((JLabel)delegateRendererComponent);
        } else {
            this.label.applyPropertiesTo(this.delegateRenderer);
        }
    }

    public void setAntiAliasedText(boolean antiAlias) {
        this.antiAliasedText = antiAlias;
    }

    public boolean getAntiAliasedText() {
        return this.antiAliasedText;
    }

    @Override
    public void setBackground(Color background) {
        if (this.label != null) {
            Color old = this.getBackground();
            this.label.setBackground(background);
            this.firePropertyChange("background", old, this.getBackground());
        }
    }

    @Override
    public Color getBackground() {
        return this.label.getBackground();
    }

    @Override
    public void setForeground(Color foreground) {
        if (this.label != null) {
            Color old = this.getForeground();
            this.label.setForeground(foreground);
            this.firePropertyChange("foreground", old, this.getForeground());
        }
    }

    @Override
    public Color getForeground() {
        return this.label.getForeground();
    }

    @Override
    public void setFont(Font font) {
        if (this.label != null) {
            Font old = this.getFont();
            this.label.setFont(font);
            this.firePropertyChange("font", old, this.getFont());
        }
    }

    @Override
    public Font getFont() {
        return this.label.getFont();
    }

    public void setDownIcon(Icon icon) {
        Icon old = this.getDownIcon();
        this.downIcon = icon;
        this.firePropertyChange("downIcon", old, this.getDownIcon());
    }

    public Icon getDownIcon() {
        return this.downIcon;
    }

    public void setUpIcon(Icon icon) {
        Icon old = this.getUpIcon();
        this.upIcon = icon;
        this.firePropertyChange("upIcon", old, this.getUpIcon());
    }

    public Icon getUpIcon() {
        return this.upIcon;
    }

    public void setHorizontalAlignment(int alignment) {
        int old = this.getHorizontalAlignment();
        this.label.setHorizontalAlignment(alignment);
        this.firePropertyChange("horizontalAlignment", old, this.getHorizontalAlignment());
    }

    public int getHorizontalAlignment() {
        return this.label.getHorizontalAlignment();
    }

    public void setHorizontalTextPosition(int textPosition) {
        int old = this.getHorizontalTextPosition();
        this.label.setHorizontalTextPosition(textPosition);
        this.firePropertyChange("horizontalTextPosition", old, this.getHorizontalTextPosition());
    }

    public int getHorizontalTextPosition() {
        return this.label.getHorizontalTextPosition();
    }

    public void setIcon(Icon icon) {
        Icon old = this.getIcon();
        this.label.setIcon(icon);
        this.firePropertyChange("icon", old, this.getIcon());
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setIconTextGap(int iconTextGap) {
        int old = this.getIconTextGap();
        this.label.setIconTextGap(iconTextGap);
        this.firePropertyChange("iconTextGap", old, this.getIconTextGap());
    }

    public int getIconTextGap() {
        return this.label.getIconTextGap();
    }

    public void setVerticalAlignment(int alignment) {
        int old = this.getVerticalAlignment();
        this.label.setVerticalAlignment(alignment);
        this.firePropertyChange("verticalAlignment", old, this.getVerticalAlignment());
    }

    public int getVerticalAlignment() {
        return this.label.getVerticalAlignment();
    }

    public void setVerticalTextPosition(int textPosition) {
        int old = this.getVerticalTextPosition();
        this.label.setVerticalTextPosition(textPosition);
        this.firePropertyChange("verticalTextPosition", old, this.getVerticalTextPosition());
    }

    public int getVerticalTextPosition() {
        return this.label.getVerticalTextPosition();
    }

    public TableCellRenderer getDelegateRenderer() {
        return this.delegateRenderer;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.initDelegate();
        this.updateIconUI();
    }

    public void updateUI(JTableHeader header) {
        this.updateIconUI();
        if (header.getDefaultRenderer() != this) {
            this.delegateRenderer = header.getDefaultRenderer();
        }
    }

    private void updateIconUI() {
        Icon icon;
        if (this.getUpIcon() instanceof UIResource) {
            icon = UIManager.getIcon(UP_ICON_KEY);
            this.setUpIcon(icon != null ? icon : defaultUpIcon);
        }
        if (this.getDownIcon() instanceof UIResource) {
            icon = UIManager.getIcon(DOWN_ICON_KEY);
            this.setDownIcon(icon != null ? icon : defaultDownIcon);
        }
    }

    static {
        LookAndFeelAddons.contribute(new ColumnHeaderRendererAddon());
        sharedInstance = null;
        defaultDownIcon = new SortArrowIcon(false);
        defaultUpIcon = new SortArrowIcon(true);
    }
}

