/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.IllegalPropertyRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.framework.util.CalendarConversionUtil;
import org.seasar.framework.util.ConstructorUtil;
import org.seasar.framework.util.DateConversionUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ModifierUtil;
import org.seasar.framework.util.NumberConversionUtil;
import org.seasar.framework.util.SqlDateConversionUtil;
import org.seasar.framework.util.TimeConversionUtil;
import org.seasar.framework.util.TimestampConversionUtil;

public final class PropertyDescImpl
implements PropertyDesc {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private String propertyName;
    private Class propertyType;
    private Method readMethod;
    private Method writeMethod;
    private Field field;
    private BeanDesc beanDesc;
    private Constructor stringConstructor;
    private Method valueOfMethod;

    public PropertyDescImpl(String propertyName, Class propertyType, Method readMethod, Method writeMethod, BeanDesc beanDesc) {
        this(propertyName, propertyType, readMethod, writeMethod, null, beanDesc);
    }

    public PropertyDescImpl(String propertyName, Class propertyType, Method readMethod, Method writeMethod, Field field, BeanDesc beanDesc) {
        if (propertyName == null) {
            throw new EmptyRuntimeException("propertyName");
        }
        if (propertyType == null) {
            throw new EmptyRuntimeException("propertyType");
        }
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.field = field;
        this.beanDesc = beanDesc;
        this.setupStringConstructor();
        this.setupValueOfMethod();
    }

    private void setupStringConstructor() {
        Constructor<?>[] cons = this.propertyType.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            Constructor<?> con = cons[i];
            if (con.getParameterTypes().length != 1 || !con.getParameterTypes()[0].equals(class$java$lang$String == null ? PropertyDescImpl.class$("java.lang.String") : class$java$lang$String)) continue;
            this.stringConstructor = con;
            break;
        }
    }

    private void setupValueOfMethod() {
        Method[] methods = this.propertyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!ModifierUtil.isStatic(method.getModifiers()) || !method.getName().equals("valueOf") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(class$java$lang$String == null ? PropertyDescImpl.class$("java.lang.String") : class$java$lang$String)) continue;
            this.valueOfMethod = method;
            break;
        }
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public final Class getPropertyType() {
        return this.propertyType;
    }

    public final Method getReadMethod() {
        return this.readMethod;
    }

    public final void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
    }

    public final boolean hasReadMethod() {
        return this.readMethod != null;
    }

    public final Method getWriteMethod() {
        return this.writeMethod;
    }

    public final void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
    }

    public final boolean hasWriteMethod() {
        return this.writeMethod != null;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public boolean isReadable() {
        return this.hasReadMethod() || this.field != null;
    }

    public boolean isWritable() {
        return this.hasWriteMethod() || this.field != null;
    }

    public final Object getValue(Object target) {
        if (this.hasReadMethod()) {
            return MethodUtil.invoke(this.readMethod, target, EMPTY_ARGS);
        }
        if (this.field != null) {
            return FieldUtil.get(this.field, target);
        }
        throw new IllegalStateException("not readable");
    }

    public final void setValue(Object target, Object value) {
        block4: {
            try {
                value = this.convertIfNeed(value);
                if (this.hasWriteMethod()) {
                    MethodUtil.invoke(this.writeMethod, target, new Object[]{value});
                    break block4;
                }
                if (this.field != null) {
                    FieldUtil.set(this.field, target, value);
                    break block4;
                }
                throw new IllegalStateException("not writable");
            }
            catch (Throwable t) {
                throw new IllegalPropertyRuntimeException(this.beanDesc.getBeanClass(), this.propertyName, t);
            }
        }
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("propertyName=");
        buf.append(this.propertyName);
        buf.append(",propertyType=");
        buf.append(this.propertyType.getName());
        buf.append(",readMethod=");
        buf.append(this.readMethod != null ? this.readMethod.getName() : "null");
        buf.append(",writeMethod=");
        buf.append(this.writeMethod != null ? this.writeMethod.getName() : "null");
        return buf.toString();
    }

    public Object convertIfNeed(Object arg) {
        if (this.propertyType.isPrimitive()) {
            return this.convertPrimitiveWrapper(arg);
        }
        if (Number.class.isAssignableFrom(this.propertyType)) {
            return this.convertNumber(arg);
        }
        if (java.util.Date.class.isAssignableFrom(this.propertyType)) {
            return this.convertDate(arg);
        }
        if (Boolean.class.isAssignableFrom(this.propertyType)) {
            return BooleanConversionUtil.toBoolean(arg);
        }
        if (arg instanceof String && !String.class.equals(this.propertyType)) {
            return this.convertWithString(arg);
        }
        if (Calendar.class.isAssignableFrom(this.propertyType)) {
            return CalendarConversionUtil.toCalendar(arg);
        }
        return arg;
    }

    private Object convertPrimitiveWrapper(Object arg) {
        return NumberConversionUtil.convertPrimitiveWrapper(this.propertyType, arg);
    }

    private Object convertNumber(Object arg) {
        return NumberConversionUtil.convertNumber(this.propertyType, arg);
    }

    private Object convertDate(Object arg) {
        if (this.propertyType == java.util.Date.class) {
            return DateConversionUtil.toDate(arg);
        }
        if (this.propertyType == Timestamp.class) {
            return TimestampConversionUtil.toTimestamp(arg);
        }
        if (this.propertyType == Date.class) {
            return SqlDateConversionUtil.toDate(arg);
        }
        if (this.propertyType == Time.class) {
            return TimeConversionUtil.toTime(arg);
        }
        return arg;
    }

    private Object convertWithString(Object arg) {
        if (this.stringConstructor != null) {
            return ConstructorUtil.newInstance(this.stringConstructor, new Object[]{arg});
        }
        if (this.valueOfMethod != null) {
            return MethodUtil.invoke(this.valueOfMethod, null, new Object[]{arg});
        }
        return arg;
    }
}

