/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.lang.reflect.Field;
import org.seasar.framework.beans.IllegalPropertyRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.BindingTypeDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.util.BindingUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.StringUtil;

public abstract class AbstractBindingTypeDef
implements BindingTypeDef {
    private String name;

    protected AbstractBindingTypeDef(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BindingTypeDef)) {
            return false;
        }
        BindingTypeDef other = (BindingTypeDef)o;
        return this.name == null ? other.getName() == null : this.name.equals(other.getName());
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public void bind(ComponentDef componentDef, PropertyDef propertyDef, PropertyDesc propertyDesc, Object component) {
        if (propertyDef != null && propertyDef.isValueGettable()) {
            if (propertyDesc != null && propertyDesc.hasWriteMethod()) {
                this.bindManual(componentDef, propertyDef, propertyDesc, component);
            }
        } else if (propertyDesc != null && propertyDesc.hasWriteMethod()) {
            this.doBind(componentDef, propertyDesc, component);
        }
    }

    public void bind(ComponentDef componentDef, PropertyDef propertyDef, Field field, Object component) {
        if (propertyDef != null && propertyDef.isValueGettable()) {
            if (field != null) {
                this.bindManual(componentDef, propertyDef, field, component);
            }
        } else if (propertyDef != null && field != null) {
            this.doBind(componentDef, field, component);
        }
    }

    protected void bindManual(ComponentDef componentDef, PropertyDef propertyDef, Field field, Object component) {
        Object value = this.getValue(componentDef, propertyDef, component);
        this.setValue(componentDef, field, component, value);
    }

    protected void bindManual(ComponentDef componentDef, PropertyDef propertyDef, PropertyDesc propertyDesc, Object component) {
        Object value = this.getValue(componentDef, propertyDef, component);
        this.setValue(componentDef, propertyDesc, component, value);
    }

    protected boolean bindAuto(ComponentDef componentDef, Field field, Object component) {
        Class<?> clazz;
        Object[] values;
        Object value;
        ComponentDef cd;
        S2Container container = componentDef.getContainer();
        String propName = field.getName();
        Class<?> propType = field.getType();
        if (container.hasComponentDef(propType) && (cd = container.getComponentDef(propType)).getComponentName() != null && (cd.getComponentName().equalsIgnoreCase(propName) || StringUtil.endsWithIgnoreCase(cd.getComponentName(), '_' + propName))) {
            Object value2 = this.getValue(componentDef, propType, component, propName);
            this.setValue(componentDef, field, component, value2);
            return true;
        }
        if (container.hasComponentDef(propName) && propType.isInstance(value = this.getValue(componentDef, propName, component, propName))) {
            this.setValue(componentDef, field, component, value);
            return true;
        }
        if (BindingUtil.isAutoBindable(propType)) {
            if (container.hasComponentDef(propType)) {
                value = this.getValue(componentDef, propType, component, propName);
                this.setValue(componentDef, field, component, value);
                return true;
            }
            if (propType.isAssignableFrom(ComponentDef.class)) {
                this.setValue(componentDef, field, component, (Object)componentDef);
                return true;
            }
        }
        if (BindingUtil.isAutoBindableArray(propType) && (values = container.findAllComponents(clazz = propType.getComponentType())).length > 0) {
            this.setValue(componentDef, field, component, (Object)values);
            return true;
        }
        return false;
    }

    protected boolean bindAuto(ComponentDef componentDef, PropertyDesc propertyDesc, Object component) {
        Class<?> clazz;
        Object[] values;
        Object value;
        ComponentDef cd;
        S2Container container = componentDef.getContainer();
        String propName = propertyDesc.getPropertyName();
        Class propType = propertyDesc.getPropertyType();
        if (container.hasComponentDef(propType) && (cd = container.getComponentDef(propType)).getComponentName() != null && (cd.getComponentName().equalsIgnoreCase(propName) || StringUtil.endsWithIgnoreCase(cd.getComponentName(), '_' + propName))) {
            Object value2 = this.getValue(componentDef, propType, component, propName);
            this.setValue(componentDef, propertyDesc, component, value2);
            return true;
        }
        if (container.hasComponentDef(propName) && propType.isInstance(value = this.getValue(componentDef, propName, component, propName))) {
            this.setValue(componentDef, propertyDesc, component, value);
            return true;
        }
        if (BindingUtil.isAutoBindable(propType)) {
            if (container.hasComponentDef(propType)) {
                value = this.getValue(componentDef, propType, component, propName);
                this.setValue(componentDef, propertyDesc, component, value);
                return true;
            }
            if (propType.isAssignableFrom(ComponentDef.class)) {
                this.setValue(componentDef, propertyDesc, component, (Object)componentDef);
                return true;
            }
        }
        if (BindingUtil.isAutoBindableArray(propType) && (values = container.findAllComponents(clazz = propType.getComponentType())).length > 0) {
            this.setValue(componentDef, propertyDesc, component, (Object)values);
            return true;
        }
        return false;
    }

    protected Object getValue(ComponentDef componentDef, PropertyDef propertyDef, Object component) throws IllegalPropertyRuntimeException {
        try {
            return propertyDef.getValue();
        }
        catch (RuntimeException cause) {
            throw new IllegalPropertyRuntimeException(BindingUtil.getComponentClass(componentDef, component), propertyDef.getPropertyName(), (Throwable)cause);
        }
    }

    protected Object getValue(ComponentDef componentDef, Object key, Object component, String propertyName) throws IllegalPropertyRuntimeException {
        try {
            return componentDef.getContainer().getComponent(key);
        }
        catch (RuntimeException cause) {
            throw new IllegalPropertyRuntimeException(BindingUtil.getComponentClass(componentDef, component), propertyName, (Throwable)cause);
        }
    }

    protected void setValue(ComponentDef componentDef, PropertyDesc propertyDesc, Object component, Object value) throws IllegalPropertyRuntimeException {
        if (value == null) {
            return;
        }
        try {
            propertyDesc.setValue(component, value);
        }
        catch (NumberFormatException ex) {
            throw new IllegalPropertyRuntimeException(componentDef.getComponentClass(), propertyDesc.getPropertyName(), (Throwable)ex);
        }
    }

    protected void setValue(ComponentDef componentDef, Field field, Object component, Object value) throws IllegalPropertyRuntimeException {
        if (value == null) {
            return;
        }
        try {
            FieldUtil.set(field, component, value);
        }
        catch (NumberFormatException ex) {
            throw new IllegalPropertyRuntimeException(componentDef.getComponentClass(), field.getName(), (Throwable)ex);
        }
    }

    protected abstract void doBind(ComponentDef var1, PropertyDesc var2, Object var3);

    protected abstract void doBind(ComponentDef var1, Field var2, Object var3);
}

