/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.IllegalPropertyRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.PropertyAssembler;
import org.seasar.framework.container.assembler.AbstractAssembler;
import org.seasar.framework.exception.EmptyRuntimeException;

public abstract class AbstractPropertyAssembler
extends AbstractAssembler
implements PropertyAssembler {
    public AbstractPropertyAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    protected void bindExternally(BeanDesc beanDesc, ComponentDef componentDef, Object component, Set names) throws EmptyRuntimeException {
        ExternalContext extCtx = componentDef.getContainer().getRoot().getExternalContext();
        if (extCtx == null) {
            throw new EmptyRuntimeException("externalContext");
        }
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            Object value;
            String name;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (!pd.hasWriteMethod() || names.contains(name = pd.getPropertyName()) || (value = this.getValue(name, pd.getPropertyType(), extCtx)) == null) continue;
            try {
                pd.setValue(component, value);
                names.add(name);
                continue;
            }
            catch (IllegalPropertyRuntimeException ignore) {
                // empty catch block
            }
        }
    }

    protected Object getValue(String name, Class type, ExternalContext extCtx) {
        Object[] values;
        if (type.isArray()) {
            Object[] values2 = this.getValues(name, extCtx);
            if (values2 != null) {
                return values2;
            }
        } else if (List.class.isAssignableFrom(type) && (values = this.getValues(name, extCtx)) != null) {
            return Arrays.asList(values);
        }
        return this.getValue(name, extCtx);
    }

    protected Object getValue(String name, ExternalContext extCtx) {
        Object value = extCtx.getRequestParameterMap().get(name);
        if (value != null) {
            return value;
        }
        value = extCtx.getRequestHeaderMap().get(name);
        if (value != null) {
            return value;
        }
        return extCtx.getRequestMap().get(name);
    }

    protected Object[] getValues(String name, ExternalContext extCtx) {
        Object[] values = (Object[])extCtx.getRequestParameterValuesMap().get(name);
        if (values != null && values.length > 0) {
            return values;
        }
        values = (Object[])extCtx.getRequestHeaderValuesMap().get(name);
        if (values != null && values.length > 0) {
            return values;
        }
        return null;
    }
}

