/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.seasar.framework.util.ClassUtil;

public final class ClassTraversal {
    private static final String CLASS_SUFFIX = ".class";
    private static final String WAR_FILE_EXTENSION = ".war";
    private static final String WEB_INF_CLASSES_PATH = "WEB-INF/classes/";

    private ClassTraversal() {
    }

    public static void forEach(File rootDir, ClassHandler handler) {
        ClassTraversal.forEach(rootDir, null, handler);
    }

    public static void forEach(File rootDir, String rootPackage, ClassHandler handler) {
        File packageDir = ClassTraversal.getPackageDir(rootDir, rootPackage);
        if (packageDir.exists()) {
            ClassTraversal.traverseFileSystem(packageDir, rootPackage, handler);
        }
    }

    public static void forEach(JarFile jarFile, ClassHandler handler) {
        boolean hasWarExtension = jarFile.getName().endsWith(WAR_FILE_EXTENSION);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            String entryName = entry.getName().replace('\\', '/');
            if (!entryName.endsWith(CLASS_SUFFIX)) continue;
            int startPos = hasWarExtension && entryName.startsWith(WEB_INF_CLASSES_PATH) ? WEB_INF_CLASSES_PATH.length() : 0;
            String className = entryName.substring(startPos, entryName.length() - CLASS_SUFFIX.length()).replace('/', '.');
            int pos = className.lastIndexOf(46);
            String packageName = pos == -1 ? null : className.substring(0, pos);
            String shortClassName = pos == -1 ? className : className.substring(pos + 1);
            handler.processClass(packageName, shortClassName);
        }
    }

    private static void traverseFileSystem(File dir, String packageName, ClassHandler handler) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String fileName = file.getName();
            if (file.isDirectory()) {
                ClassTraversal.traverseFileSystem(file, ClassUtil.concatName(packageName, fileName), handler);
                continue;
            }
            if (!fileName.endsWith(CLASS_SUFFIX)) continue;
            String shortClassName = fileName.substring(0, fileName.length() - CLASS_SUFFIX.length());
            handler.processClass(packageName, shortClassName);
        }
    }

    private static File getPackageDir(File rootDir, String rootPackage) {
        File packageDir = rootDir;
        if (rootPackage != null) {
            String[] names = rootPackage.split("\\.");
            for (int i = 0; i < names.length; ++i) {
                packageDir = new File(packageDir, names[i]);
            }
        }
        return packageDir;
    }

    public static interface ClassHandler {
        public void processClass(String var1, String var2);
    }
}

