/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.seasar.framework.exception.IORuntimeException;

public final class InputStreamUtil {
    private InputStreamUtil() {
    }

    public static void close(InputStream is) throws IORuntimeException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final byte[] getBytes(InputStream is) throws IORuntimeException {
        byte[] bytes = null;
        byte[] buf = new byte[8192];
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, n);
            }
            bytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (is != null) {
                InputStreamUtil.close(is);
            }
        }
        return bytes;
    }

    public static final void copy(InputStream is, OutputStream os) throws IORuntimeException {
        byte[] buf = new byte[8192];
        try {
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) != -1) {
                os.write(buf, 0, n);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static int available(InputStream is) throws IORuntimeException {
        try {
            return is.available();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

