/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.GenericElementHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerBundle;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericElementHandlerEnviroment {
    private static final Log log = LogFactory.getLog(GenericElementHandlerEnviroment.class);
    private static final ReferenceMap handlersCache = new ReferenceMap(2, 0);

    public static GenericElementHandler getHandler(JRGenericElementType type, String exporterKey) {
        Map<String, GenericElementHandlerBundle> handlerBundles = GenericElementHandlerEnviroment.getHandlerBundles();
        GenericElementHandlerBundle bundle = handlerBundles.get(type.getNamespace());
        if (bundle == null) {
            throw new JRRuntimeException("No generic element handlers found for namespace " + type.getNamespace());
        }
        return bundle.getHandler(type.getName(), exporterKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map<String, GenericElementHandlerBundle> getHandlerBundles() {
        Map<String, GenericElementHandlerBundle> handlerBundles;
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap referenceMap = handlersCache;
        synchronized (referenceMap) {
            handlerBundles = (Map<String, GenericElementHandlerBundle>)handlersCache.get(cacheKey);
            if (handlerBundles == null) {
                handlerBundles = GenericElementHandlerEnviroment.loadHandlerBundles();
                handlersCache.put(cacheKey, handlerBundles);
            }
        }
        return handlerBundles;
    }

    protected static Map<String, GenericElementHandlerBundle> loadHandlerBundles() {
        List<GenericElementHandlerBundle> bundleList = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(GenericElementHandlerBundle.class);
        HashMap<String, GenericElementHandlerBundle> bundles = new HashMap<String, GenericElementHandlerBundle>();
        for (GenericElementHandlerBundle bundle : bundleList) {
            String namespace = bundle.getNamespace();
            if (bundles.containsKey(namespace)) {
                log.warn((Object)("Found two generic element handler bundles for namespace " + namespace));
                continue;
            }
            bundles.put(namespace, bundle);
        }
        return bundles;
    }

    private GenericElementHandlerEnviroment() {
    }
}

