/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.util.ReportExecutionHyperlinkProducerFactory;

public abstract class AbstractViewer {
    public static final String REQUEST_PARAMETER_PAGE = "jr.page";
    protected static final String TEMPLATE_HEADER_NOPAGES = "net/sf/jasperreports/web/servlets/resources/templates/HeaderTemplateNoPages.vm";
    protected static final String TEMPLATE_FOOTER_NOPAGES = "net/sf/jasperreports/web/servlets/resources/templates/FooterTemplateNoPages.vm";

    public void render(HttpServletRequest request, WebReportContext webReportContext, PrintWriter writer) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print");
        JRXhtmlExporter exporter = new JRXhtmlExporter();
        boolean hasPages = true;
        exporter.setReportContext(webReportContext);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_WRITER, writer);
        exporter.setParameter(JRHtmlExporterParameter.IMAGES_URI, "image?jr.ctxid=" + webReportContext.getId() + "&image=");
        if (jasperPrint.getPages().size() > 0) {
            String reportPage = request.getParameter(REQUEST_PARAMETER_PAGE);
            if (reportPage == null) {
                reportPage = "0";
            }
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, Integer.parseInt(reportPage));
        } else {
            hasPages = false;
        }
        exporter.setParameter(JRHtmlExporterParameter.HTML_HEADER, this.getHeader(request, webReportContext, hasPages));
        exporter.setParameter(JRHtmlExporterParameter.BETWEEN_PAGES_HTML, this.getBetweenPages(request, webReportContext));
        exporter.setParameter(JRHtmlExporterParameter.HTML_FOOTER, this.getFooter(request, webReportContext, hasPages));
        exporter.setParameter(JRHtmlExporterParameter.HYPERLINK_PRODUCER_FACTORY, ReportExecutionHyperlinkProducerFactory.getInstance(request));
        exporter.exportReport();
    }

    protected String getCurrentUrl(HttpServletRequest request, WebReportContext webReportContext) {
        String newQueryString = "";
        newQueryString = "jr.uri=" + webReportContext.getParameterValue("jr.uri") + "&" + "jr.dsr" + "=" + webReportContext.getParameterValue("jr.dsr") + "&" + "jr.ctxid" + "=" + webReportContext.getId();
        return request.getContextPath() + request.getServletPath() + "?" + newQueryString;
    }

    protected abstract String getHeader(HttpServletRequest var1, WebReportContext var2, boolean var3);

    protected abstract String getBetweenPages(HttpServletRequest var1, WebReportContext var2);

    protected abstract String getFooter(HttpServletRequest var1, WebReportContext var2, boolean var3);
}

