/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.ApplicationModel;
import org.jhotdraw.app.Project;
import org.jhotdraw.beans.AbstractBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApplicationModel
extends AbstractBean
implements ApplicationModel {
    private HashMap<String, Action> actions;
    private String name;
    private String version;
    private String copyright;
    private Class projectClass;
    private String projectClassName;

    public void setName(String newValue) {
        String oldValue = this.name;
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setVersion(String newValue) {
        String oldValue = this.version;
        this.version = newValue;
        this.firePropertyChange("version", oldValue, newValue);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setCopyright(String newValue) {
        String oldValue = this.copyright;
        this.copyright = newValue;
        this.firePropertyChange("copyright", oldValue, newValue);
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    public void setProjectClassName(String newValue) {
        String oldValue = this.projectClassName;
        this.projectClassName = newValue;
        this.firePropertyChange("projectClassName", oldValue, newValue);
    }

    public void setProjectClass(Class newValue) {
        Class oldValue = this.projectClass;
        this.projectClass = newValue;
        this.firePropertyChange("projectClass", oldValue, newValue);
    }

    public Class getProjectClass() {
        if (this.projectClass == null && this.projectClassName != null) {
            try {
                this.projectClass = Class.forName(this.projectClassName);
            }
            catch (Exception e) {
                InternalError error = new InternalError("unable to get project class");
                error.initCause(e);
                throw error;
            }
        }
        return this.projectClass;
    }

    @Override
    public Project createProject() {
        try {
            return (Project)this.getProjectClass().newInstance();
        }
        catch (Exception e) {
            InternalError error = new InternalError("unable to create project");
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public List<JToolBar> createToolBars(Application a, Project p) {
        return new LinkedList<JToolBar>();
    }

    @Override
    public List<JMenu> createMenus(Application a, Project p) {
        return new LinkedList<JMenu>();
    }

    @Override
    public void initProject(Application a, Project p) {
    }

    @Override
    public void initApplication(Application a) {
    }

    @Override
    public Action getAction(String id) {
        return this.actions == null ? null : this.actions.get(id);
    }

    @Override
    public void putAction(String id, Action action) {
        if (this.actions == null) {
            this.actions = new HashMap();
        }
        if (action == null) {
            this.actions.remove(id);
        } else {
            this.actions.put(id, action);
        }
    }
}

