/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Project;
import org.jhotdraw.app.action.AbstractProjectAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.util.Methods;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.Worker;

public class ExportAction
extends AbstractProjectAction {
    public static final String ID = "export";
    private Component oldFocusOwner;

    public ExportAction(Application app) {
        super(app);
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
        labels.configureAction(this, ID);
    }

    private JFileChooser getExportChooser(Project project) {
        try {
            return (JFileChooser)Methods.invoke(project, "getExportChooser");
        }
        catch (Throwable e) {
            InternalError error = new InternalError("Project does not support exporting");
            error.initCause(e);
            throw error;
        }
    }

    public void actionPerformed(ActionEvent evt) {
        final Project project = this.getCurrentProject();
        if (project.isEnabled()) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.app.Labels");
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(project.getComponent()).getFocusOwner();
            project.setEnabled(false);
            JFileChooser fileChooser = this.getExportChooser(project);
            JSheet.showSheet(fileChooser, project.getComponent(), labels.getString("filechooser.export"), new SheetListener(){

                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        File file = evt.getFileChooser().getSelectedFile();
                        ExportAction.this.exportToFile(project, file, evt.getFileChooser().getFileFilter(), evt.getFileChooser().getAccessory());
                    } else {
                        project.setEnabled(true);
                        if (ExportAction.this.oldFocusOwner != null) {
                            ExportAction.this.oldFocusOwner.requestFocus();
                        }
                    }
                }
            });
        }
    }

    protected void exportToFile(final Project project, final File file, final FileFilter filter, final Component accessory) {
        project.execute(new Worker(){

            public Object construct() {
                try {
                    Methods.invoke((Object)project, ExportAction.ID, new Class[]{File.class, FileFilter.class, Component.class}, file, filter, accessory);
                    return null;
                }
                catch (InternalError e) {
                    return e.getCause() != null ? e.getCause() : e;
                }
                catch (Throwable e) {
                    return e;
                }
            }

            public void finished(Object value) {
                ExportAction.this.fileExported(project, file, value);
            }
        });
    }

    protected void fileExported(Project project, File file, Object value) {
        if (value != null) {
            System.out.flush();
            ((Throwable)value).printStackTrace();
            JSheet.showMessageSheet((Component)project.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't export to the file \"" + file + "\".<p>" + "Reason: " + value), 0);
        }
        project.setEnabled(true);
        SwingUtilities.getWindowAncestor(project.getComponent()).toFront();
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
    }
}

