/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.lang.reflect.TypeVariable;
import org.jhotdraw.draw.Figure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeKey<T> {
    private String key;
    private T defaultValue;
    private boolean isNullValueAllowed;

    public AttributeKey(String key) {
        this(key, null, true);
    }

    public AttributeKey(String key, T defaultValue) {
        this(key, defaultValue, true);
    }

    public AttributeKey(String key, T defaultValue, boolean isNullValueAllowed) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.isNullValueAllowed = isNullValueAllowed;
    }

    public String getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T get(Figure f) {
        Object value = f.getAttribute(this);
        return (T)(value == null && !this.isNullValueAllowed ? this.defaultValue : value);
    }

    public void set(Figure f, T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        f.setAttribute(this, value);
    }

    public void basicSet(Figure f, T value) {
        if (value == null && !this.isNullValueAllowed) {
            throw new NullPointerException("Null value not allowed for AttributeKey " + this.key);
        }
        f.basicSetAttribute(this, value);
    }

    public boolean equals(Object o) {
        if (o instanceof AttributeKey) {
            AttributeKey that = (AttributeKey)o;
            return that.key.equals(this.key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }

    public boolean isNullValueAllowed() {
        return this.isNullValueAllowed;
    }

    public static void main(String[] args) {
        TypeVariable<Class<?>> v = new AttributeKey("hey").getClass().getTypeParameters()[0];
    }

    public boolean isAssignable(Object value) {
        if (value == null) {
            return this.isNullValueAllowed();
        }
        try {
            Object a = value;
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

