/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Liner;

public abstract class ChangeConnectionHandle
extends AbstractHandle {
    private Connector originalTarget;
    private Figure targetFigure;
    private ConnectionFigure connection;
    private Point start;
    private Liner liner;

    protected ChangeConnectionHandle(Figure owner) {
        super(owner);
        this.setConnection((ConnectionFigure)owner);
        this.setTargetFigure(null);
    }

    public boolean isCombinableWith(Handle handle) {
        return false;
    }

    protected abstract Connector getTarget();

    protected abstract void disconnect();

    protected abstract void connect(Connector var1);

    protected abstract void setLocation(Point2D.Double var1);

    protected abstract Point2D.Double getLocation();

    protected Connector getSource() {
        if (this.getTarget() == this.getConnection().getStartConnector()) {
            return this.getConnection().getEndConnector();
        }
        return this.getConnection().getStartConnector();
    }

    public void trackStart(Point anchor, int modifiersEx) {
        this.originalTarget = this.getTarget();
        this.start = anchor;
        this.liner = this.connection.getLiner();
        this.connection.setLiner(null);
    }

    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        Connector target;
        Point2D.Double p = this.view.viewToDrawing(lead);
        Figure f = this.findConnectableFigure(p, this.view.getDrawing());
        if (f != this.getTargetFigure()) {
            if (this.getTargetFigure() != null) {
                this.getTargetFigure().setConnectorsVisible(false, null);
            }
            this.setTargetFigure(f);
            if (this.getSource() == null) {
                if (this.getTargetFigure() != null) {
                    this.getTargetFigure().setConnectorsVisible(true, this.getConnection());
                }
            } else if (this.getTargetFigure() != null && this.canConnect(this.getSource().getOwner(), this.getTargetFigure())) {
                this.getTargetFigure().setConnectorsVisible(true, this.getConnection());
            }
        }
        if ((target = this.findConnectionTarget(p, this.view.getDrawing())) != null) {
            p = target.getAnchor();
        }
        this.setLocation(p);
    }

    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        Point2D.Double p = this.view.viewToDrawing(lead);
        Connector target = this.findConnectionTarget(p, this.view.getDrawing());
        if (target == null) {
            target = this.originalTarget;
        }
        this.setLocation(p);
        if (target != this.originalTarget) {
            this.disconnect();
            this.connect(target);
        }
        this.connection.setLiner(this.liner);
        this.getConnection().updateConnection();
        if (this.getTargetFigure() != null) {
            this.getTargetFigure().setConnectorsVisible(false, null);
            this.setTargetFigure(null);
        }
    }

    private Connector findConnectionTarget(Point2D.Double p, Drawing drawing) {
        Figure targetFigure = this.findConnectableFigure(p, drawing);
        if (this.getSource() == null && targetFigure != null) {
            return this.findConnector(p, targetFigure, this.getConnection());
        }
        if (targetFigure != null && targetFigure.canConnect() && targetFigure != this.originalTarget && !targetFigure.includes(this.getOwner()) && this.canConnect(this.getSource().getOwner(), targetFigure)) {
            return this.findConnector(p, targetFigure, this.getConnection());
        }
        return null;
    }

    protected abstract boolean canConnect(Figure var1, Figure var2);

    protected Connector findConnector(Point2D.Double p, Figure f, ConnectionFigure prototype) {
        return f.findConnector(p, prototype);
    }

    public void draw(Graphics2D g) {
        this.drawCircle(g, this.getTarget() == null ? Color.red : Color.green, Color.black);
    }

    private Figure findConnectableFigure(Point2D.Double p, Drawing drawing) {
        for (Figure f : drawing.getFiguresFrontToBack()) {
            if (f.includes(this.getConnection()) || !f.canConnect() || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    protected void setConnection(ConnectionFigure newConnection) {
        this.connection = newConnection;
    }

    protected ConnectionFigure getConnection() {
        return this.connection;
    }

    protected void setTargetFigure(Figure newTarget) {
        this.targetFigure = newTarget;
    }

    protected Figure getTargetFigure() {
        return this.targetFigure;
    }

    protected Rectangle basicGetBounds() {
        Point center = this.view.drawingToView(this.getLocation());
        return new Rectangle(center.x - this.getHandlesize() / 2, center.y - this.getHandlesize() / 2, this.getHandlesize(), this.getHandlesize());
    }
}

