/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ChopBoxConnector;
import org.jhotdraw.draw.DiamondFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Geom;

public class ChopDiamondConnector
extends ChopBoxConnector {
    public ChopDiamondConnector() {
    }

    public ChopDiamondConnector(Figure owner) {
        super(owner);
    }

    protected Point2D.Double chop(Figure target, Point2D.Double from) {
        double growx;
        double growy;
        target = this.getConnectorTarget(target);
        Rectangle2D.Double r = target.getBounds();
        if (DiamondFigure.IS_QUADRATIC.get(target).booleanValue()) {
            double side = Math.max(r.width, r.height);
            r.x -= (side - r.width) / 2.0;
            r.y -= (side - r.height) / 2.0;
            r.width = r.height = side;
        }
        switch (AttributeKeys.STROKE_PLACEMENT.get(target)) {
            case INSIDE: {
                growy = 0.0;
                growx = 0.0;
                break;
            }
            case OUTSIDE: {
                double lineLength = Math.sqrt(r.width * r.width + r.height * r.height);
                double scale = AttributeKeys.getStrokeTotalWidth(target) * 2.0 / lineLength;
                growx = scale * r.height;
                growy = scale * r.width;
                break;
            }
            default: {
                double lineLength = Math.sqrt(r.width * r.width + r.height * r.height);
                double scale = AttributeKeys.getStrokeTotalWidth(target) / lineLength;
                growx = scale * r.height;
                growy = scale * r.width;
            }
        }
        Geom.grow(r, growx, growy);
        Point2D.Double c1 = new Point2D.Double(r.x + r.width / 2.0, r.y + r.height / 2.0);
        Point2D.Double p2 = new Point2D.Double(r.x + r.width / 2.0, r.y + r.height);
        Point2D.Double p4 = new Point2D.Double(r.x + r.width / 2.0, r.y);
        if (r.contains(from)) {
            if (from.y > r.y && from.y < r.y + r.height / 2.0) {
                return p2;
            }
            return p4;
        }
        double ang = Geom.pointToAngle(r, from);
        Point2D.Double p1 = new Point2D.Double(r.x + r.width, r.y + r.height / 2.0);
        Point2D.Double p3 = new Point2D.Double(r.x, r.y + r.height / 2.0);
        Point2D.Double rp = null;
        if (ang > 0.0 && ang < 1.57) {
            rp = Geom.intersect(p1.x, p1.y, p2.x, p2.y, c1.x, c1.y, from.x, from.y);
        } else if (ang > 1.575 && ang < 3.14) {
            rp = Geom.intersect(p2.x, p2.y, p3.x, p3.y, c1.x, c1.y, from.x, from.y);
        } else if (ang > -3.14 && ang < -1.575) {
            rp = Geom.intersect(p3.x, p3.y, p4.x, p4.y, c1.x, c1.y, from.x, from.y);
        } else if (ang > -1.57 && ang < 0.0) {
            rp = Geom.intersect(p4.x, p4.y, p1.x, p1.y, c1.x, c1.y, from.x, from.y);
        }
        if (rp == null) {
            rp = Geom.angleToPoint(r, ang);
        }
        return rp;
    }
}

