/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.Liner;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElbowLiner
implements Liner,
DOMStorable {
    @Override
    public Collection<Handle> createHandles(BezierPath path) {
        return null;
    }

    @Override
    public void lineout(ConnectionFigure figure) {
        BezierPath path = ((LineConnectionFigure)figure).getBezierPath();
        Connector start = figure.getStartConnector();
        Connector end = figure.getEndConnector();
        if (start == null || end == null || path == null) {
            return;
        }
        Point2D.Double sp = start.findStart(figure);
        Point2D.Double ep = end.findEnd(figure);
        path.clear();
        path.add(new BezierPath.Node(sp.x, sp.y));
        if (sp.x == ep.x || sp.y == ep.y) {
            path.add(new BezierPath.Node(ep.x, ep.y));
        } else {
            int eoutcode;
            Rectangle2D.Double sb = start.getBounds();
            sb.x += 5.0;
            sb.y += 5.0;
            sb.width -= 10.0;
            sb.height -= 10.0;
            Rectangle2D.Double eb = end.getBounds();
            eb.x += 5.0;
            eb.y += 5.0;
            eb.width -= 10.0;
            eb.height -= 10.0;
            int soutcode = sb.outcode(sp);
            if (soutcode == 0) {
                soutcode = Geom.outcode(sb, eb);
            }
            if ((eoutcode = eb.outcode(ep)) == 0) {
                eoutcode = Geom.outcode(eb, sb);
            }
            if ((soutcode & 0xA) != 0 && (eoutcode & 0xA) != 0) {
                path.add(new BezierPath.Node(sp.x, (sp.y + ep.y) / 2.0));
                path.add(new BezierPath.Node(ep.x, (sp.y + ep.y) / 2.0));
            } else if ((soutcode & 5) != 0 && (eoutcode & 5) != 0) {
                path.add(new BezierPath.Node((sp.x + ep.x) / 2.0, sp.y));
                path.add(new BezierPath.Node((sp.x + ep.x) / 2.0, ep.y));
            }
            path.add(new BezierPath.Node(ep.x, ep.y));
        }
        path.invalidatePath();
    }

    @Override
    public void read(DOMInput in) {
    }

    @Override
    public void write(DOMOutput out) {
    }

    @Override
    public Liner clone() {
        try {
            return (Liner)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError(ex.getMessage());
            error.initCause(ex);
            throw error;
        }
    }
}

