/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.TextHolder;

public class FloatingTextArea {
    protected JScrollPane editScrollContainer;
    protected JTextArea editWidget = new JTextArea();
    protected DrawingView view;

    public FloatingTextArea() {
        this.editWidget.setWrapStyleWord(true);
        this.editWidget.setLineWrap(true);
        this.editScrollContainer = new JScrollPane(this.editWidget, 22, 31);
        this.editScrollContainer.setCursor(Cursor.getPredefinedCursor(0));
        this.editScrollContainer.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    public void createOverlay(DrawingView view) {
        this.createOverlay(view, null);
    }

    public void requestFocus() {
        this.editWidget.requestFocus();
    }

    public void createOverlay(DrawingView view, TextHolder figure) {
        view.getContainer().add((Component)this.editScrollContainer, 0);
        if (figure != null) {
            Font f = figure.getFont();
            f = f.deriveFont(f.getStyle(), (float)((double)f.getSize() * view.getScaleFactor()));
            this.editWidget.setFont(f);
            this.editWidget.setForeground(figure.getTextColor());
            this.editWidget.setBackground(figure.getFillColor());
            this.editWidget.setTabSize(figure.getTabSize());
        }
        this.view = view;
    }

    public void setBounds(Rectangle2D.Double r, String text) {
        this.editWidget.setText(text);
        this.editScrollContainer.setBounds(this.view.drawingToView(r));
        this.editScrollContainer.setVisible(true);
        this.editWidget.setCaretPosition(0);
        this.editWidget.requestFocus();
    }

    public String getText() {
        return this.editWidget.getText();
    }

    public Dimension getPreferredSize(int cols) {
        return new Dimension(this.editWidget.getWidth(), this.editWidget.getHeight());
    }

    public void endOverlay() {
        this.view.getContainer().requestFocus();
        if (this.editScrollContainer != null) {
            this.editScrollContainer.setVisible(false);
            this.view.getContainer().remove(this.editScrollContainer);
            Rectangle bounds = this.editScrollContainer.getBounds();
            this.view.getContainer().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }
}

