/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierNodeHandle;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.geom.BezierPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineFigure
extends BezierFigure {
    public LineFigure() {
        this.basicAddNode(new BezierPath.Node(new Point2D.Double(0.0, 0.0)));
        this.basicAddNode(new BezierPath.Node(new Point2D.Double(0.0, 0.0)));
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel) {
            case 0: {
                int n = this.path.size();
                for (int i = 0; i < n; ++i) {
                    handles.add(new BezierNodeHandle(this, i));
                }
                break;
            }
        }
        return handles;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        if (evt.getClickCount() == 2 && view.getHandleDetailLevel() == 0) {
            this.willChange();
            final int index = this.basicSplitSegment(p, (float)(5.0 / view.getScaleFactor()));
            if (index != -1) {
                final BezierPath.Node newNode = this.getNode(index);
                this.fireUndoableEditHappened(new AbstractUndoableEdit(){

                    public void redo() throws CannotRedoException {
                        super.redo();
                        LineFigure.this.willChange();
                        LineFigure.this.basicAddNode(index, newNode);
                        LineFigure.this.changed();
                    }

                    public void undo() throws CannotUndoException {
                        super.undo();
                        LineFigure.this.willChange();
                        LineFigure.this.basicRemoveNode(index);
                        LineFigure.this.changed();
                    }
                });
                this.changed();
                return true;
            }
        }
        return false;
    }
}

