/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractDrawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureLayerComparator;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.geom.QuadTree2DDouble;
import org.jhotdraw.util.ReversedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadTreeDrawing
extends AbstractDrawing
implements FigureListener,
UndoableEditListener {
    private ArrayList<Figure> figures = new ArrayList();
    private QuadTree2DDouble<Figure> quadTree = new QuadTree2DDouble();
    private boolean needsSorting = false;

    @Override
    protected int indexOf(Figure figure) {
        return this.figures.indexOf(figure);
    }

    @Override
    public void basicAdd(int index, Figure figure) {
        this.figures.add(index, figure);
        this.quadTree.add(figure, figure.getDrawBounds());
        figure.addFigureListener(this);
        figure.addUndoableEditListener(this);
        this.needsSorting = true;
    }

    @Override
    public void basicRemove(Figure figure) {
        this.figures.remove(figure);
        this.quadTree.remove(figure);
        figure.removeFigureListener(this);
        figure.removeUndoableEditListener(this);
        this.needsSorting = true;
    }

    @Override
    public void draw(Graphics2D g) {
        Collection<Figure> c = this.quadTree.findIntersects(g.getClipBounds().getBounds2D());
        Collection<Figure> toDraw = this.sort(c);
        this.draw(g, toDraw);
    }

    @Override
    public Collection<Figure> sort(Collection<Figure> c) {
        this.ensureSorted();
        ArrayList<Figure> sorted = new ArrayList<Figure>(c.size());
        for (Figure f : this.figures) {
            if (!c.contains(f)) continue;
            sorted.add(f);
        }
        return sorted;
    }

    public void draw(Graphics2D g, Collection<Figure> c) {
        for (Figure f : c) {
            f.draw(g);
        }
    }

    @Override
    public void figureAreaInvalidated(FigureEvent e) {
        this.fireAreaInvalidated(e.getInvalidatedArea());
    }

    @Override
    public void figureChanged(FigureEvent e) {
        this.quadTree.remove(e.getFigure());
        this.quadTree.add(e.getFigure(), e.getFigure().getDrawBounds());
        this.needsSorting = true;
        this.fireAreaInvalidated(e.getInvalidatedArea());
    }

    @Override
    public void figureAdded(FigureEvent e) {
    }

    @Override
    public void figureRemoved(FigureEvent e) {
    }

    @Override
    public void figureRequestRemove(FigureEvent e) {
        this.remove(e.getFigure());
    }

    public Collection<Figure> getFigures(Rectangle2D.Double bounds) {
        return this.quadTree.findInside(bounds);
    }

    @Override
    public Collection<Figure> getFigures() {
        return Collections.unmodifiableCollection(this.figures);
    }

    @Override
    public Figure findFigureInside(Point2D.Double p) {
        Collection<Figure> c = this.quadTree.findContains(p);
        for (Figure f : this.getFiguresFrontToBack()) {
            if (!c.contains(f) || !f.contains(p)) continue;
            return f.findFigureInside(p);
        }
        return null;
    }

    @Override
    public List<Figure> getFiguresFrontToBack() {
        this.ensureSorted();
        return new ReversedList<Figure>(this.figures);
    }

    @Override
    public Figure findFigure(Point2D.Double p) {
        Collection<Figure> c = this.quadTree.findContains(p);
        switch (c.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure f = c.iterator().next();
                return f.contains(p) ? f : null;
            }
        }
        for (Figure f : this.getFiguresFrontToBack()) {
            if (!c.contains(f) || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double p, Figure ignore) {
        Collection<Figure> c = this.quadTree.findContains(p);
        switch (c.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure f = c.iterator().next();
                return f == ignore || !f.contains(p) ? null : f;
            }
        }
        for (Figure f : this.getFiguresFrontToBack()) {
            if (f == ignore || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    public Figure findFigureExcept(Point2D.Double p, Collection ignore) {
        Collection<Figure> c = this.quadTree.findContains(p);
        switch (c.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure f = c.iterator().next();
                return !ignore.contains(f) || !f.contains(p) ? null : f;
            }
        }
        for (Figure f : this.getFiguresFrontToBack()) {
            if (ignore.contains(f) || !f.contains(p)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Collection<Figure> findFigures(Rectangle2D.Double r) {
        Collection<Figure> c = this.quadTree.findIntersects(r);
        switch (c.size()) {
            case 0: 
            case 1: {
                return c;
            }
        }
        return this.sort(c);
    }

    @Override
    public Collection<Figure> findFiguresWithin(Rectangle2D.Double r) {
        Collection<Figure> c = this.findFigures(r);
        ArrayList<Figure> result = new ArrayList<Figure>(c.size());
        for (Figure f : c) {
            if (!r.contains(f.getBounds())) continue;
            result.add(f);
        }
        return result;
    }

    @Override
    public void bringToFront(Figure figure) {
        if (this.figures.remove(figure)) {
            this.figures.add(figure);
            this.needsSorting = true;
            this.fireAreaInvalidated(figure.getDrawBounds());
        }
    }

    @Override
    public void sendToBack(Figure figure) {
        if (this.figures.remove(figure)) {
            this.figures.add(0, figure);
            this.needsSorting = true;
            this.fireAreaInvalidated(figure.getDrawBounds());
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.fireUndoableEditHappened(e.getEdit());
    }

    @Override
    public void figureAttributeChanged(FigureEvent e) {
    }

    @Override
    public boolean contains(Figure f) {
        return this.figures.contains(f);
    }

    private void ensureSorted() {
        if (this.needsSorting) {
            Collections.sort(this.figures, FigureLayerComparator.INSTANCE);
            this.needsSorting = false;
        }
    }
}

