/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.draw.ChopRoundRectConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.RoundRectRadiusHandle;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundRectangleFigure
extends AttributedFigure {
    private RoundRectangle2D.Double roundrect;
    private static final double DEFAULT_ARC = 20.0;

    public RoundRectangleFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public RoundRectangleFigure(double x, double y, double width, double height) {
        this.roundrect = new RoundRectangle2D.Double(x, y, width, height, 20.0, 20.0);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.roundrect.getBounds2D();
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        Rectangle2D.Double r = (Rectangle2D.Double)this.roundrect.getBounds2D();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this);
        Geom.grow(r, grow, grow);
        return r;
    }

    public double getArcWidth() {
        return this.roundrect.arcwidth;
    }

    public double getArcHeight() {
        return this.roundrect.archeight;
    }

    public void setArc(final double w, final double h) {
        final double oldWidth = this.roundrect.getArcWidth();
        final double oldHeight = this.roundrect.getArcHeight();
        this.roundrect.arcwidth = w;
        this.roundrect.archeight = h;
        this.fireFigureChanged(this.getDrawBounds());
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return "Rundung";
            }

            public void undo() throws CannotUndoException {
                super.undo();
                RoundRectangleFigure.this.willChange();
                ((RoundRectangleFigure)RoundRectangleFigure.this).roundrect.arcwidth = oldWidth;
                ((RoundRectangleFigure)RoundRectangleFigure.this).roundrect.archeight = oldHeight;
                RoundRectangleFigure.this.changed();
            }

            public void redo() throws CannotRedoException {
                super.redo();
                RoundRectangleFigure.this.willChange();
                ((RoundRectangleFigure)RoundRectangleFigure.this).roundrect.arcwidth = w;
                ((RoundRectangleFigure)RoundRectangleFigure.this).roundrect.archeight = h;
                RoundRectangleFigure.this.changed();
            }
        });
    }

    @Override
    protected void drawFill(Graphics2D g) {
        RoundRectangle2D.Double r = (RoundRectangle2D.Double)this.roundrect.clone();
        double grow = AttributeKeys.getPerpendicularFillGrowth(this);
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        r.arcwidth += grow * 2.0;
        r.archeight += grow * 2.0;
        if (r.width > 0.0 && r.height > 0.0) {
            g.fill(r);
        }
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        RoundRectangle2D.Double r = (RoundRectangle2D.Double)this.roundrect.clone();
        double grow = AttributeKeys.getPerpendicularDrawGrowth(this);
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        r.arcwidth += grow * 2.0;
        r.archeight += grow * 2.0;
        if (r.width > 0.0 && r.height > 0.0) {
            g.draw(r);
        }
    }

    @Override
    public boolean contains(Point2D.Double p) {
        RoundRectangle2D.Double r = (RoundRectangle2D.Double)this.roundrect.clone();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this);
        r.x -= grow;
        r.y -= grow;
        r.width += grow * 2.0;
        r.height += grow * 2.0;
        r.arcwidth += grow * 2.0;
        r.archeight += grow * 2.0;
        return r.contains(p);
    }

    @Override
    public void basicSetBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.roundrect.x = Math.min(anchor.x, lead.x);
        this.roundrect.y = Math.min(anchor.y, lead.y);
        this.roundrect.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.roundrect.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
    }

    @Override
    public void basicTransform(AffineTransform tx) {
        Point2D.Double anchor = this.getStartPoint();
        Point2D.Double lead = this.getEndPoint();
        this.basicSetBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList handles = (LinkedList)super.createHandles(detailLevel);
        handles.add(new RoundRectRadiusHandle(this));
        return handles;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return new ChopRoundRectConnector(this);
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return new ChopRoundRectConnector(this);
    }

    @Override
    public RoundRectangleFigure clone() {
        RoundRectangleFigure that = (RoundRectangleFigure)super.clone();
        that.roundrect = (RoundRectangle2D.Double)this.roundrect.clone();
        return that;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        super.read(in);
        this.roundrect.arcwidth = in.getAttribute("arcWidth", 20.0);
        this.roundrect.archeight = in.getAttribute("arcHeight", 20.0);
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        super.write(out);
        out.addAttribute("arcWidth", this.roundrect.arcwidth);
        out.addAttribute("arcHeight", this.roundrect.archeight);
    }

    @Override
    public void restoreTo(Object geometry) {
        RoundRectangle2D.Double r = (RoundRectangle2D.Double)geometry;
        this.roundrect.x = r.x;
        this.roundrect.y = r.y;
        this.roundrect.width = r.width;
        this.roundrect.height = r.height;
    }

    @Override
    public Object getRestoreData() {
        return this.roundrect.clone();
    }

    public Point2D.Double chop(Point2D.Double from) {
        double grow;
        Rectangle2D.Double outer = this.getBounds();
        switch (AttributeKeys.STROKE_PLACEMENT.get(this)) {
            default: {
                grow = AttributeKeys.getStrokeTotalWidth(this) / 2.0;
                break;
            }
            case OUTSIDE: {
                grow = AttributeKeys.getStrokeTotalWidth(this);
                break;
            }
            case INSIDE: {
                grow = 0.0;
            }
        }
        outer.x -= grow;
        outer.y -= grow;
        outer.width += grow * 2.0;
        outer.height += grow * 2.0;
        Rectangle2D.Double inner = (Rectangle2D.Double)outer.clone();
        double gw = -(this.getArcWidth() + grow * 2.0) / 2.0;
        double gh = -(this.getArcHeight() + grow * 2.0) / 2.0;
        inner.x -= gw;
        inner.y -= gh;
        inner.width += gw * 2.0;
        inner.height += gh * 2.0;
        double angle = Geom.pointToAngle(outer, from);
        Point2D.Double p = Geom.angleToPoint(outer, Geom.pointToAngle(outer, from));
        if (p.x == outer.x || p.x == outer.x + outer.width) {
            p.y = Math.min(Math.max(p.y, inner.y), inner.y + inner.height);
        } else {
            p.x = Math.min(Math.max(p.x, inner.x), inner.x + inner.width);
        }
        return p;
    }
}

