/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jhotdraw.draw.AbstractTool;

public class SelectAreaTracker
extends AbstractTool {
    private Rectangle rubberBand = new Rectangle();

    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        this.clearRubberBand();
    }

    public void mouseReleased(MouseEvent evt) {
        this.selectGroup(evt.isShiftDown());
        this.clearRubberBand();
    }

    public void mouseDragged(MouseEvent evt) {
        Rectangle invalidatedArea = (Rectangle)this.rubberBand.clone();
        this.rubberBand.setBounds(Math.min(this.anchor.x, evt.getX()), Math.min(this.anchor.y, evt.getY()), Math.abs(this.anchor.x - evt.getX()), Math.abs(this.anchor.y - evt.getY()));
        invalidatedArea = invalidatedArea.isEmpty() ? (Rectangle)this.rubberBand.clone() : invalidatedArea.union(this.rubberBand);
        this.fireAreaInvalidated(invalidatedArea);
    }

    public void mouseMoved(MouseEvent evt) {
        this.clearRubberBand();
        this.updateCursor(this.editor.findView((Container)evt.getSource()), new Point(evt.getX(), evt.getY()));
    }

    private void clearRubberBand() {
        if (this.rubberBand.width > 0) {
            this.fireAreaInvalidated(this.rubberBand);
            this.rubberBand.width = 0;
        }
    }

    public void draw(Graphics2D g) {
        g.setStroke(new BasicStroke());
        g.setColor(Color.black);
        g.drawRect(this.rubberBand.x, this.rubberBand.y, this.rubberBand.width - 1, this.rubberBand.height - 1);
    }

    private void selectGroup(boolean toggle) {
        this.getView().addToSelection(this.getView().findFiguresWithin(this.rubberBand));
    }
}

