/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FloatingTextArea;
import org.jhotdraw.draw.TextHolder;
import org.jhotdraw.geom.Insets2DDouble;

public class TextAreaTool
extends CreationTool
implements ActionListener {
    private FloatingTextArea textArea;
    private TextHolder typingTarget;

    public TextAreaTool(TextHolder prototype) {
        super(prototype);
    }

    public void deactivate(DrawingEditor editor) {
        this.endEdit();
        super.deactivate(editor);
    }

    public void mousePressed(MouseEvent e) {
        TextHolder textHolder = null;
        Figure pressedFigure = this.getDrawing().findFigureInside(this.getView().viewToDrawing(new Point(e.getX(), e.getY())));
        if (pressedFigure instanceof TextHolder && !(textHolder = (TextHolder)pressedFigure).isEditable()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.createdFigure = null;
            this.beginEdit(textHolder);
            return;
        }
        if (this.typingTarget != null) {
            this.endEdit();
            this.fireToolDone();
        } else {
            super.mousePressed(e);
        }
    }

    protected void beginEdit(TextHolder textHolder) {
        if (this.textArea == null) {
            this.textArea = new FloatingTextArea();
        }
        if (textHolder != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textArea.createOverlay(this.getView(), textHolder);
        this.textArea.setBounds(this.getFieldBounds(textHolder), textHolder.getText());
        this.textArea.requestFocus();
        this.typingTarget = textHolder;
    }

    private Rectangle2D.Double getFieldBounds(TextHolder figure) {
        Rectangle2D.Double r = figure.getBounds();
        Insets2DDouble insets = figure.getInsets();
        r = new Rectangle2D.Double(r.x + insets.left, r.y + insets.top, r.width - insets.left - insets.right, r.height - insets.top - insets.bottom);
        r.x -= 1.0;
        r.y -= 2.0;
        r.width += 18.0;
        r.height += 4.0;
        return r;
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.createdFigure != null) {
            TextHolder textHolder = (TextHolder)this.createdFigure;
            Rectangle2D.Double bounds = this.createdFigure.getBounds();
            if (bounds.width == 0.0 && bounds.height == 0.0) {
                this.getDrawing().remove(this.createdFigure);
            } else {
                if (bounds.width < 5.0 && bounds.height < 5.0) {
                    this.createdFigure.willChange();
                    this.createdFigure.basicSetBounds(new Point2D.Double(bounds.x, bounds.y), new Point2D.Double(bounds.x + 100.0, bounds.y + 100.0));
                    this.createdFigure.changed();
                }
                this.getView().addToSelection(this.createdFigure);
            }
            if (this.createdFigure instanceof CompositeFigure) {
                ((CompositeFigure)this.createdFigure).layout();
            }
            this.createdFigure = null;
            this.getDrawing().fireUndoableEditHappened(this.creationEdit);
            this.beginEdit(textHolder);
        }
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            if (this.textArea.getText().length() > 0) {
                this.typingTarget.setText(this.textArea.getText());
                if (this.createdFigure != null) {
                    this.getDrawing().fireUndoableEditHappened(this.creationEdit);
                    this.createdFigure = null;
                }
            } else if (this.createdFigure != null) {
                this.getDrawing().remove(this.getAddedFigure());
            } else {
                this.typingTarget.setText("");
            }
            this.typingTarget = null;
            this.textArea.endOverlay();
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.endEdit();
        this.fireToolDone();
    }
}

