/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.draw.FontSizeHandle;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TextHolder;
import org.jhotdraw.draw.TextTool;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2DDouble;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFigure
extends AttributedFigure
implements TextHolder {
    protected Point2D.Double origin = new Point2D.Double();
    private boolean editable = true;
    private transient TextLayout textLayout;

    public TextFigure() {
        this("Text");
    }

    public TextFigure(String text) {
        this.setText(text);
    }

    @Override
    public String getText() {
        return (String)this.getAttribute(AttributeKeys.TEXT);
    }

    @Override
    public void setText(String newText) {
        this.setAttribute(AttributeKeys.TEXT, newText);
    }

    @Override
    public void basicTransform(AffineTransform tx) {
        tx.transform(this.origin, this.origin);
    }

    @Override
    public void basicSetBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.origin = new Point2D.Double(anchor.x, anchor.y);
    }

    @Override
    public boolean contains(Point2D.Double p) {
        if (this.getBounds().contains(p)) {
            return true;
        }
        if (this.decorator != null) {
            this.updateDecoratorBounds();
            return this.decorator.contains(p);
        }
        return false;
    }

    @Override
    protected void drawStroke(Graphics2D g) {
    }

    @Override
    protected void drawFill(Graphics2D g) {
    }

    @Override
    protected void drawText(Graphics2D g) {
        if (this.getText() != null || this.isEditable()) {
            TextLayout layout = this.getTextLayout();
            layout.draw(g, (float)this.origin.x, (float)(this.origin.y + (double)layout.getAscent()));
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.textLayout = null;
    }

    protected TextLayout getTextLayout() {
        if (this.textLayout == null) {
            String text = this.getText();
            if (text == null || text.length() == 0) {
                text = " ";
            }
            FontRenderContext frc = this.getFontRenderContext();
            HashMap<TextAttribute, Serializable> textAttributes = new HashMap<TextAttribute, Serializable>();
            textAttributes.put(TextAttribute.FONT, this.getFont());
            if (AttributeKeys.FONT_UNDERLINED.get(this).booleanValue()) {
                textAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            }
            this.textLayout = new TextLayout(text, textAttributes, frc);
        }
        return this.textLayout;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        TextLayout layout = this.getTextLayout();
        Rectangle2D.Double r = new Rectangle2D.Double(this.origin.x, this.origin.y, layout.getAdvance(), layout.getAscent() + layout.getDescent());
        return r;
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        Rectangle2D.Double b = this.getBounds();
        return new Dimension2DDouble(b.width, b.height);
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        if (this.getText() == null) {
            return this.getBounds();
        }
        TextLayout layout = this.getTextLayout();
        Rectangle2D.Double r = new Rectangle2D.Double(this.origin.x, this.origin.y, layout.getAdvance(), layout.getAscent());
        Rectangle2D lBounds = layout.getBounds();
        if (!lBounds.isEmpty() && !Double.isNaN(lBounds.getX())) {
            r.add(new Rectangle2D.Double(lBounds.getX() + this.origin.x, lBounds.getY() + this.origin.y + (double)layout.getAscent(), lBounds.getWidth(), lBounds.getHeight()));
        }
        Geom.grow(r, 2.0, 2.0);
        return r;
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
            handles.add(new MoveHandle(this, RelativeLocator.northWest()));
            handles.add(new MoveHandle(this, RelativeLocator.northEast()));
            handles.add(new MoveHandle(this, RelativeLocator.southEast()));
            handles.add(new FontSizeHandle(this));
        }
        return handles;
    }

    @Override
    protected void validate() {
        super.validate();
        this.textLayout = null;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    @Override
    public int getTextColumns() {
        return this.getText() == null ? 4 : Math.max(this.getText().length(), 4);
    }

    @Override
    public Tool getTool(Point2D.Double p) {
        return this.isEditable() && this.contains(p) ? new TextTool(this) : null;
    }

    @Override
    public void read(DOMInput in) throws IOException {
        this.setBounds(new Point2D.Double(in.getAttribute("x", 0.0), in.getAttribute("y", 0.0)), new Point2D.Double(0.0, 0.0));
        this.readAttributes(in);
    }

    @Override
    public void write(DOMOutput out) throws IOException {
        Rectangle2D.Double b = this.getBounds();
        out.addAttribute("x", b.x);
        out.addAttribute("y", b.y);
        this.writeAttributes(out);
    }

    @Override
    public int getTabSize() {
        return 8;
    }

    @Override
    public TextHolder getLabelFor() {
        return this;
    }

    @Override
    public Insets2DDouble getInsets() {
        return new Insets2DDouble(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void restoreTo(Object geometry) {
        Point2D.Double p = (Point2D.Double)geometry;
        this.origin.x = p.x;
        this.origin.y = p.y;
    }

    @Override
    public Object getRestoreData() {
        return this.origin.clone();
    }

    @Override
    public TextFigure clone() {
        TextFigure that = (TextFigure)super.clone();
        that.origin = (Point2D.Double)this.origin.clone();
        that.textLayout = null;
        return that;
    }

    @Override
    public Font getFont() {
        return AttributeKeys.getFont(this);
    }

    @Override
    public Color getTextColor() {
        return AttributeKeys.TEXT_COLOR.get(this);
    }

    @Override
    public Color getFillColor() {
        return AttributeKeys.FILL_COLOR.get(this);
    }

    @Override
    public void setFontSize(float size) {
        AttributeKeys.FONT_SIZE.set(this, new Double(size));
    }

    @Override
    public float getFontSize() {
        return AttributeKeys.FONT_SIZE.get(this).floatValue();
    }
}

