/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.draw.ChopTriangleConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TriangleRotationHandler;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriangleFigure
extends AttributedFigure {
    private Rectangle2D.Double rectangle;

    public TriangleFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public TriangleFigure(AttributeKeys.Orientation direction) {
        this(0.0, 0.0, 0.0, 0.0, direction);
    }

    public TriangleFigure(double x, double y, double width, double height) {
        this(x, y, width, height, AttributeKeys.Orientation.NORTH);
    }

    public TriangleFigure(double x, double y, double width, double height, AttributeKeys.Orientation direction) {
        this.rectangle = new Rectangle2D.Double(x, y, width, height);
        AttributeKeys.ORIENTATION.set(this, direction);
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return new ChopTriangleConnector(this);
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return new ChopTriangleConnector(this);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double bounds = (Rectangle2D.Double)this.rectangle.clone();
        return bounds;
    }

    @Override
    protected void drawFill(Graphics2D g) {
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        Shape triangle = this.getBezierPath();
        double grow = AttributeKeys.getPerpendicularFillGrowth(this);
        if (grow != 0.0) {
            GrowStroke gs = new GrowStroke((float)grow, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this)));
            triangle = gs.createStrokedShape(triangle);
        }
        g.fill(triangle);
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        Shape triangle = this.getBezierPath();
        double grow = AttributeKeys.getPerpendicularDrawGrowth(this);
        if (grow != 0.0) {
            GrowStroke gs = new GrowStroke((float)grow, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this)));
            triangle = gs.createStrokedShape(triangle);
        }
        g.draw(triangle);
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList handles = (LinkedList)super.createHandles(detailLevel);
        if (detailLevel == 0) {
            handles.add(new TriangleRotationHandler(this));
        }
        return handles;
    }

    public BezierPath getBezierPath() {
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        BezierPath triangle = new BezierPath();
        switch (AttributeKeys.ORIENTATION.get(this)) {
            default: {
                triangle.moveTo((float)(r.x + r.width / 2.0), (float)r.y);
                triangle.lineTo((float)(r.x + r.width), (float)(r.y + r.height));
                triangle.lineTo((float)r.x, (float)(r.y + r.height));
                break;
            }
            case NORTH_EAST: {
                triangle.moveTo((float)r.x, (float)r.y);
                triangle.lineTo((float)(r.x + r.width), (float)r.y);
                triangle.lineTo((float)(r.x + r.width), (float)(r.y + r.height));
                break;
            }
            case EAST: {
                triangle.moveTo((float)r.x, (float)r.y);
                triangle.lineTo((float)(r.x + r.width), (float)(r.y + r.height / 2.0));
                triangle.lineTo((float)r.x, (float)(r.y + r.height));
                break;
            }
            case SOUTH_EAST: {
                triangle.moveTo((float)(r.x + r.width), (float)r.y);
                triangle.lineTo((float)(r.x + r.width), (float)(r.y + r.height));
                triangle.lineTo((float)r.x, (float)(r.y + r.height));
                break;
            }
            case SOUTH: {
                triangle.moveTo((float)(r.x + r.width / 2.0), (float)(r.y + r.height));
                triangle.lineTo((float)r.x, (float)r.y);
                triangle.lineTo((float)(r.x + r.width), (float)r.y);
                break;
            }
            case SOUTH_WEST: {
                triangle.moveTo((float)(r.x + r.width), (float)(r.y + r.height));
                triangle.lineTo((float)r.x, (float)(r.y + r.height));
                triangle.lineTo((float)r.x, (float)r.y);
                break;
            }
            case WEST: {
                triangle.moveTo((float)r.x, (float)(r.y + r.height / 2.0));
                triangle.lineTo((float)(r.x + r.width), (float)r.y);
                triangle.lineTo((float)(r.x + r.width), (float)(r.y + r.height));
                break;
            }
            case NORTH_WEST: {
                triangle.moveTo((float)r.x, (float)(r.y + r.height));
                triangle.lineTo((float)r.x, (float)r.y);
                triangle.lineTo((float)(r.x + r.width), (float)r.y);
            }
        }
        triangle.setClosed(true);
        return triangle;
    }

    @Override
    public boolean contains(Point2D.Double p) {
        Shape triangle = this.getBezierPath();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this);
        if (grow != 0.0) {
            GrowStroke gs = new GrowStroke((float)grow, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this)));
            triangle = gs.createStrokedShape(triangle);
        }
        return triangle.contains(p);
    }

    @Override
    public void basicSetBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.rectangle.x = Math.min(anchor.x, lead.x);
        this.rectangle.y = Math.min(anchor.y, lead.y);
        this.rectangle.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.rectangle.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        double totalStrokeWidth = AttributeKeys.getStrokeTotalWidth(this);
        double width = 0.0;
        if (AttributeKeys.STROKE_COLOR.get(this) != null) {
            switch (AttributeKeys.STROKE_PLACEMENT.get(this)) {
                case INSIDE: {
                    width = 0.0;
                    break;
                }
                case OUTSIDE: {
                    if (AttributeKeys.STROKE_JOIN.get(this) == 0) {
                        width = totalStrokeWidth * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this);
                        break;
                    }
                    width = totalStrokeWidth;
                    break;
                }
                case CENTER: {
                    width = AttributeKeys.STROKE_JOIN.get(this) == 0 ? totalStrokeWidth / 2.0 * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this) : totalStrokeWidth / 2.0;
                }
            }
        }
        Rectangle2D.Double r = this.getBounds();
        Geom.grow(r, width += 1.0, width);
        return r;
    }

    public Point2D.Double chop(Point2D.Double p) {
        Shape triangle = this.getBezierPath();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this);
        if (grow != 0.0) {
            GrowStroke gs = new GrowStroke((float)grow, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this)));
            triangle = gs.createStrokedShape(triangle);
        }
        return Geom.chop(triangle, p);
    }

    @Override
    public void basicTransform(AffineTransform tx) {
        Point2D.Double anchor = this.getStartPoint();
        Point2D.Double lead = this.getEndPoint();
        this.basicSetBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
    }

    @Override
    public TriangleFigure clone() {
        TriangleFigure that = (TriangleFigure)super.clone();
        that.rectangle = (Rectangle2D.Double)this.rectangle.clone();
        return that;
    }

    @Override
    public void restoreTo(Object geometry) {
        Rectangle2D.Double r = (Rectangle2D.Double)geometry;
        this.rectangle.x = r.x;
        this.rectangle.y = r.y;
        this.rectangle.width = r.width;
        this.rectangle.height = r.height;
    }

    @Override
    public Object getRestoreData() {
        return this.rectangle.clone();
    }
}

