/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractViewAction
extends AbstractAction {
    private DrawingEditor editor;
    private DrawingView view;
    protected static final ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
    private PropertyChangeListener propertyChangeHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                AbstractViewAction.this.updateEnabledState();
            }
        }
    };

    public AbstractViewAction(DrawingEditor editor) {
        this.editor = editor;
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("view")) {
                    DrawingView view;
                    if (evt.getOldValue() != null) {
                        view = (DrawingView)evt.getOldValue();
                        view.removePropertyChangeListener(AbstractViewAction.this.propertyChangeHandler);
                    }
                    if (evt.getNewValue() != null) {
                        view = (DrawingView)evt.getOldValue();
                        view.addPropertyChangeListener(AbstractViewAction.this.propertyChangeHandler);
                        AbstractViewAction.this.updateEnabledState();
                    }
                }
            }
        });
    }

    public AbstractViewAction(DrawingView view) {
        this.view = view;
    }

    protected void setEditor(DrawingEditor newValue) {
        this.editor = newValue;
    }

    protected DrawingView getView() {
        return this.view != null ? this.view : this.editor.getView();
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected void fireUndoableEditHappened(UndoableEdit edit) {
        this.getDrawing().fireUndoableEditHappened(edit);
    }

    protected void viewChanged() {
    }

    public void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled() && this.getView().getSelectionCount() > 0);
        } else {
            this.setEnabled(false);
        }
    }
}

