/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class PickAttributesAction
extends AbstractSelectedAction {
    private ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());

    public PickAttributesAction(DrawingEditor editor) {
        super(editor);
        this.labels.configureAction(this, "attributesPick");
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.pickAttributes();
    }

    public void pickAttributes() {
        DrawingEditor editor = this.getEditor();
        Collection<Figure> selection = this.getView().getSelectedFigures();
        if (selection.size() > 0) {
            Figure figure = selection.iterator().next();
            for (Map.Entry<AttributeKey, Object> entry : figure.getAttributes().entrySet()) {
                if (entry.getKey() == AttributeKeys.TEXT) continue;
                editor.setDefaultAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public void selectionChanged(FigureSelectionEvent evt) {
        this.setEnabled(this.getView().getSelectionCount() == 1);
    }
}

