/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadTree2DDouble<T> {
    private HashMap<T, Rectangle2D.Double> outside = new HashMap();
    private QuadNode root;
    private int maxCapacity = 32;
    private int minSize = 32;
    private int maxOutside = 32;

    public QuadTree2DDouble() {
        this.root = new QuadNode(new Rectangle2D.Double(0.0, 0.0, 800.0, 600.0));
    }

    public QuadTree2DDouble(Rectangle2D.Double bounds) {
        this.root = new QuadNode(bounds);
    }

    public void add(T o, Rectangle2D.Double bounds) {
        if (this.root.bounds.contains(bounds)) {
            this.root.add(o, (Rectangle2D.Double)bounds.clone());
        } else {
            this.outside.put(o, (Rectangle2D.Double)bounds.clone());
            if (this.outside.size() > this.maxOutside) {
                this.reorganize();
            }
        }
    }

    public void reorganize() {
        this.root.join();
        this.outside.putAll(this.root.objects);
        this.root.objects.clear();
        Iterator<Map.Entry<T, Rectangle2D.Double>> i = this.outside.entrySet().iterator();
        Map.Entry<T, Rectangle2D.Double> entry2 = i.next();
        Rectangle2D.Double treeBounds = (Rectangle2D.Double)entry2.getValue().clone();
        while (i.hasNext()) {
            entry2 = i.next();
            Rectangle2D.Double bounds = entry2.getValue();
            treeBounds.add(bounds);
        }
        this.root.bounds = treeBounds;
        for (Map.Entry<T, Rectangle2D.Double> entry2 : this.outside.entrySet()) {
            this.root.add(entry2.getKey(), entry2.getValue());
        }
        this.outside.clear();
    }

    public void remove(T o) {
        this.outside.remove(o);
        this.root.remove(o);
    }

    public Collection<T> findContains(Point2D.Double p) {
        HashSet<T> result = new HashSet<T>();
        this.root.findContains(p, result);
        for (Map.Entry<T, Rectangle2D.Double> entry : this.outside.entrySet()) {
            if (!entry.getValue().contains(p)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public Collection<T> findIntersects(Rectangle2D r) {
        return this.findIntersects(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
    }

    public Collection<T> findIntersects(Rectangle2D.Double r) {
        HashSet<T> result = new HashSet<T>();
        this.root.findIntersects(r, result);
        for (Map.Entry<T, Rectangle2D.Double> entry : this.outside.entrySet()) {
            if (!entry.getValue().intersects(r)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public Collection<T> findInside(Rectangle2D.Double r) {
        HashSet<T> result = new HashSet<T>();
        this.root.findInside(r, result);
        for (Map.Entry<T, Rectangle2D.Double> entry : this.outside.entrySet()) {
            if (!r.contains(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QuadNode {
        private Rectangle2D.Double bounds;
        private HashMap<T, Rectangle2D.Double> objects;
        private QuadNode northEast;
        private QuadNode northWest;
        private QuadNode southEast;
        private QuadNode southWest;

        public QuadNode(Rectangle2D.Double bounds) {
            this.bounds = bounds;
            this.objects = new HashMap();
        }

        public boolean isLeaf() {
            return this.northEast == null;
        }

        public void remove(T o) {
            if (this.objects.remove(o) == null && !this.isLeaf()) {
                this.northEast.remove(o);
                this.northWest.remove(o);
                this.southEast.remove(o);
                this.southWest.remove(o);
            }
        }

        public void add(T o, Rectangle2D.Double oBounds) {
            if (this.isLeaf() && this.objects.size() >= QuadTree2DDouble.this.maxCapacity && this.bounds.width > (double)QuadTree2DDouble.this.minSize && this.bounds.height > (double)QuadTree2DDouble.this.minSize) {
                this.split();
            }
            if (this.isLeaf() || oBounds.contains(this.bounds)) {
                this.objects.put(o, oBounds);
            } else {
                if (this.northEast.bounds.intersects(oBounds)) {
                    this.northEast.add(o, oBounds);
                }
                if (this.northWest.bounds.intersects(oBounds)) {
                    this.northWest.add(o, oBounds);
                }
                if (this.southEast.bounds.intersects(oBounds)) {
                    this.southEast.add(o, oBounds);
                }
                if (this.southWest.bounds.intersects(oBounds)) {
                    this.southWest.add(o, oBounds);
                }
            }
        }

        public void split() {
            if (this.isLeaf()) {
                double hw = this.bounds.width / 2.0;
                double hh = this.bounds.height / 2.0;
                this.northWest = new QuadNode(new Rectangle2D.Double(this.bounds.x, this.bounds.y, hw, hh));
                this.northEast = new QuadNode(new Rectangle2D.Double(this.bounds.x + hw, this.bounds.y, this.bounds.width - hw, hh));
                this.southWest = new QuadNode(new Rectangle2D.Double(this.bounds.x, this.bounds.y + hh, hw, this.bounds.height - hh));
                this.southEast = new QuadNode(new Rectangle2D.Double(this.bounds.x + hw, this.bounds.y + hh, this.bounds.width - hw, this.bounds.height - hh));
                HashMap temp = this.objects;
                this.objects = new HashMap();
                for (Map.Entry entry : temp.entrySet()) {
                    this.add(entry.getKey(), entry.getValue());
                }
            }
        }

        public void join() {
            if (!this.isLeaf()) {
                this.northWest.join();
                this.northEast.join();
                this.southWest.join();
                this.southEast.join();
                this.objects.putAll(this.northWest.objects);
                this.objects.putAll(this.northEast.objects);
                this.objects.putAll(this.southWest.objects);
                this.objects.putAll(this.southEast.objects);
                this.northWest = null;
                this.northEast = null;
                this.southWest = null;
                this.southEast = null;
            }
        }

        public void findContains(Point2D.Double p, HashSet<T> result) {
            if (this.bounds.contains(p)) {
                for (Map.Entry entry : this.objects.entrySet()) {
                    if (!entry.getValue().contains(p)) continue;
                    result.add(entry.getKey());
                }
                if (!this.isLeaf()) {
                    this.northWest.findContains(p, result);
                    this.northEast.findContains(p, result);
                    this.southWest.findContains(p, result);
                    this.southEast.findContains(p, result);
                }
            }
        }

        public void findIntersects(Rectangle2D.Double r, HashSet<T> result) {
            if (this.bounds.intersects(r)) {
                int oldSize = result.size();
                for (Map.Entry entry : this.objects.entrySet()) {
                    if (!entry.getValue().intersects(r)) continue;
                    result.add(entry.getKey());
                }
                if (!this.isLeaf()) {
                    this.northWest.findIntersects(r, result);
                    this.northEast.findIntersects(r, result);
                    this.southWest.findIntersects(r, result);
                    this.southEast.findIntersects(r, result);
                }
            }
        }

        public void findInside(Rectangle2D.Double r, HashSet<T> result) {
            if (this.bounds.intersects(r)) {
                for (Map.Entry entry : this.objects.entrySet()) {
                    if (!r.contains(entry.getValue())) continue;
                    result.add(entry.getKey());
                }
                if (!this.isLeaf()) {
                    this.northWest.findInside(r, result);
                    this.northEast.findInside(r, result);
                    this.southWest.findInside(r, result);
                    this.southEast.findInside(r, result);
                }
            }
        }
    }
}

