/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.draw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.app.AbstractProject;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.ToolBarButtonFactory;
import org.jhotdraw.gui.PlacardScrollPaneLayout;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.samples.draw.DrawFigureFactory;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.xml.NanoXMLLiteDOMInput;
import org.jhotdraw.xml.NanoXMLLiteDOMOutput;

public class DrawProject
extends AbstractProject {
    private UndoRedoManager undo;
    private DrawingEditor editor;
    private JScrollPane scrollPane;
    private DefaultDrawingView view;

    public void init() {
        super.init();
        this.initComponents();
        JPanel zoomButtonPanel = new JPanel(new BorderLayout());
        this.scrollPane.setLayout(new PlacardScrollPaneLayout());
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setEditor(new DefaultDrawingEditor());
        this.view.setDOMFactory(new DrawFigureFactory());
        this.undo = new UndoRedoManager();
        this.view.setDrawing(new DefaultDrawing());
        this.view.getDrawing().addUndoableEditListener(this.undo);
        this.initActions();
        this.undo.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DrawProject.this.setHasUnsavedChanges(DrawProject.this.undo.hasSignificantEdits());
            }
        });
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPanel placardPanel = new JPanel(new BorderLayout());
        AbstractButton pButton = ToolBarButtonFactory.createZoomButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        placardPanel.add((Component)pButton, "West");
        pButton = ToolBarButtonFactory.createToggleGridButton(this.view);
        pButton.putClientProperty("Quaqua.Button.style", "placard");
        pButton.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 0));
        pButton.setFont(UIManager.getFont("SmallSystemFont"));
        labels.configureToolBarButton(pButton, "alignGridSmall");
        placardPanel.add((Component)pButton, "East");
        this.scrollPane.add((Component)placardPanel, "LOWER_LEFT_CORNER");
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.editor;
        if (oldValue != null) {
            oldValue.remove(this.view);
        }
        this.editor = newValue;
        if (newValue != null) {
            newValue.add(this.view);
        }
    }

    private void initActions() {
        this.putAction("undo", this.undo.getUndoAction());
        this.putAction("redo", this.undo.getRedoAction());
    }

    protected void setHasUnsavedChanges(boolean newValue) {
        super.setHasUnsavedChanges(newValue);
        this.undo.setHasSignificantEdits(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File f) throws IOException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(f));
            NanoXMLLiteDOMOutput domo = new NanoXMLLiteDOMOutput(this.view.getDOMFactory());
            domo.openElement("PlasmaDraw");
            domo.writeObject(this.view.getDrawing());
            domo.closeElement();
            domo.save(out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void read(File f) throws IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            NanoXMLLiteDOMInput domi = new NanoXMLLiteDOMInput(this.view.getDOMFactory(), in);
            domi.openElement("PlasmaDraw");
            final Drawing drawing = (Drawing)domi.readObject();
            domi.closeElement();
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    DrawProject.this.view.getDrawing().removeUndoableEditListener(DrawProject.this.undo);
                    DrawProject.this.view.setDrawing(drawing);
                    DrawProject.this.view.getDrawing().addUndoableEditListener(DrawProject.this.undo);
                    DrawProject.this.undo.discardAllEdits();
                }
            });
        }
        catch (InterruptedException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
        catch (InvocationTargetException e) {
            InternalError error = new InternalError();
            e.initCause(e);
            throw error;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setDrawingEditor(DrawingEditor newValue) {
        if (this.editor != null) {
            this.editor.remove(this.view);
        }
        this.editor = newValue;
        if (this.editor != null) {
            this.editor.add(this.view);
        }
    }

    public DrawingEditor getDrawingEditor() {
        return this.editor;
    }

    public void clear() {
        this.view.setDrawing(new DefaultDrawing());
        this.undo.discardAllEdits();
    }

    protected JFileChooser createOpenChooser() {
        JFileChooser c = super.createOpenChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Drawing", "xml"));
        return c;
    }

    protected JFileChooser createSaveChooser() {
        JFileChooser c = super.createSaveChooser();
        c.addChoosableFileFilter(new ExtensionFileFilter("Drawing", "xml"));
        return c;
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.setLayout(new BorderLayout());
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
    }
}

