/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Stack;
import nanoxml.XMLElement;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public class NanoXMLLiteDOMOutput
implements DOMOutput {
    private String doctype;
    private HashMap<Object, String> objectids;
    private HashMap<String, Object> prototypes;
    private XMLElement document;
    private XMLElement current;
    private DOMFactory factory;
    private Stack<XMLElement> stack;

    public NanoXMLLiteDOMOutput(DOMFactory factory) {
        this.factory = factory;
        this.objectids = new HashMap();
        this.current = this.document = new XMLElement(new HashMap(), false, false);
        this.stack = new Stack();
        this.stack.push(this.current);
    }

    public void save(OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, "UTF8");
        this.save(w);
        ((Writer)w).flush();
    }

    public void save(Writer out) throws IOException {
        if (this.doctype != null) {
            out.write("<!DOCTYPE ");
            out.write(this.doctype);
            out.write(">\n");
        }
        ((XMLElement)this.document.getChildren().get(0)).write(out);
    }

    public void print(PrintWriter out) {
        ((XMLElement)this.document.getChildren().get(0)).print(out);
    }

    public void openElement(String tagName) {
        XMLElement newElement = new XMLElement(new HashMap(), false, false);
        newElement.setName(tagName);
        this.current.addChild(newElement);
        this.stack.push(this.current);
        this.current = newElement;
    }

    public void closeElement() {
        this.current = this.stack.pop();
    }

    public void addComment(String comment) {
    }

    public void addText(String text) {
        String old = this.current.getContent();
        if (old == null) {
            this.current.setContent(text);
        } else {
            this.current.setContent(old + text);
        }
    }

    public void addAttribute(String name, String value) {
        if (value != null) {
            this.current.setAttribute(name, value);
        }
    }

    public void addAttribute(String name, int value) {
        this.current.setAttribute(name, Integer.toString(value));
    }

    public void addAttribute(String name, boolean value) {
        this.current.setAttribute(name, new Boolean(value).toString());
    }

    public void addAttribute(String name, float value) {
        String str = Float.toString(value);
        if (str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        this.current.setAttribute(name, str);
    }

    public void addAttribute(String name, double value) {
        String str = Double.toString(value);
        if (str.endsWith(".0")) {
            str = str.substring(0, str.length() - 2);
        }
        this.current.setAttribute(name, str);
    }

    public void writeObject(Object o) throws IOException {
        if (o == null) {
            this.openElement("null");
            this.closeElement();
        } else if (o instanceof DOMStorable) {
            this.writeStorable((DOMStorable)o);
        } else if (o instanceof String) {
            this.openElement("string");
            this.addText((String)o);
            this.closeElement();
        } else if (o instanceof Integer) {
            this.openElement("int");
            this.addText(o.toString());
            this.closeElement();
        } else if (o instanceof Long) {
            this.openElement("long");
            this.addText(o.toString());
            this.closeElement();
        } else if (o instanceof Double) {
            this.openElement("double");
            String str = o.toString();
            if (str.endsWith(".0")) {
                str = str.substring(0, str.length() - 2);
            }
            this.addText(str);
            this.closeElement();
        } else if (o instanceof Float) {
            this.openElement("float");
            String str = o.toString();
            if (str.endsWith(".0")) {
                str = str.substring(0, str.length() - 2);
            }
            this.addText(str);
            this.closeElement();
        } else if (o instanceof Boolean) {
            this.openElement("boolean");
            this.addText(o.toString());
            this.closeElement();
        } else if (o instanceof Color) {
            Color c = (Color)o;
            this.openElement("color");
            this.addAttribute("rgba", "#" + Integer.toHexString(c.getRGB()));
            this.closeElement();
        } else if (o instanceof int[]) {
            this.openElement("intArray");
            int[] a = (int[])o;
            for (int i = 0; i < a.length; ++i) {
                this.writeObject(new Integer(a[i]));
            }
            this.closeElement();
        } else if (o instanceof float[]) {
            this.openElement("floatArray");
            float[] a = (float[])o;
            for (int i = 0; i < a.length; ++i) {
                this.writeObject(new Float(a[i]));
            }
            this.closeElement();
        } else if (o instanceof double[]) {
            this.openElement("doubleArray");
            double[] a = (double[])o;
            for (int i = 0; i < a.length; ++i) {
                this.writeObject(new Double(a[i]));
            }
            this.closeElement();
        } else if (o instanceof Font) {
            Font f = (Font)o;
            this.openElement("font");
            this.addAttribute("name", f.getName());
            this.addAttribute("style", f.getStyle());
            this.addAttribute("size", f.getSize());
            this.closeElement();
        } else if (o instanceof Enum) {
            this.openElement("enum");
            Enum e = (Enum)o;
            this.addAttribute("type", this.factory.getEnumName(e));
            this.addText(this.factory.getEnumValue(e));
            this.closeElement();
        } else {
            throw new IllegalArgumentException("unable to store: " + o + " " + o.getClass());
        }
    }

    private XMLElement writeStorable(DOMStorable o) throws IOException {
        String tagName = this.factory.getName(o);
        if (tagName == null) {
            throw new IllegalArgumentException("no tag name for:" + o);
        }
        this.openElement(tagName);
        XMLElement element = this.current;
        if (this.objectids.containsKey(o)) {
            this.addAttribute("ref", this.objectids.get(o));
        } else {
            String id = Integer.toString(this.objectids.size(), 16);
            this.objectids.put(o, id);
            this.addAttribute("id", id);
            o.write(this);
        }
        this.closeElement();
        return element;
    }

    public void addAttribute(String name, float value, float defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, int value, int defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, double value, double defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, String value, String defaultValue) {
        if (value != null && !value.equals(defaultValue)) {
            this.addAttribute(name, value);
        }
    }

    public Object getPrototype() {
        if (this.prototypes == null) {
            this.prototypes = new HashMap();
        }
        if (!this.prototypes.containsKey(this.current.getName())) {
            this.prototypes.put(this.current.getName(), this.factory.create(this.current.getName()));
        }
        return this.prototypes.get(this.current.getName());
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }
}

