/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.javaws.Main;
import com.sun.javaws.security.AppContextUtil;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public final class JavawsSysRun
extends DeploySysRun {
    private final SecureThread t = new SecureThread();

    private void delegateFromEDT(final Job job) throws Exception {
        DummyDialog dummyDialog = new DummyDialog();
        job.setDialog(dummyDialog);
        if (Config.getOSName().equals("Windows")) {
            dummyDialog.setLocation(-200, -200);
        } else {
            Rectangle rectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
            dummyDialog.setLocation(rectangle.x + rectangle.width / 2 - 50, rectangle.y + rectangle.height / 2);
        }
        dummyDialog.setResizable(false);
        dummyDialog.toBack();
        dummyDialog.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowOpened(WindowEvent windowEvent) {
                Object object = ((JavawsSysRun)JavawsSysRun.this).t.mutex;
                synchronized (object) {
                    JavawsSysRun.this.t.addJob(job);
                    ((JavawsSysRun)JavawsSysRun.this).t.mutex.notifyAll();
                }
            }
        });
        dummyDialog.setVisible(true);
        dummyDialog.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object delegate(DeploySysAction deploySysAction) throws Exception {
        if (Main.getSecurityThreadGroup() == null || Main.getSecurityThreadGroup().equals(Thread.currentThread().getThreadGroup())) {
            return deploySysAction.execute();
        }
        Job job = new Job(deploySysAction);
        if (AppContextUtil.isApplicationAppContext() && SwingUtilities.isEventDispatchThread()) {
            this.delegateFromEDT(job);
        } else {
            Object object = this.t.mutex;
            synchronized (object) {
                this.t.addJob(job);
                this.t.mutex.notifyAll();
                while (!job.done) {
                    try {
                        this.t.mutex.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.ignoredException((Exception)interruptedException);
                    }
                }
                this.t.mutex.notifyAll();
            }
        }
        if (job.exception != null) {
            throw job.exception;
        }
        return job.result;
    }

    static void invokeLater(final Runnable runnable) {
        if (Main.getSecurityThreadGroup() == null || Main.getSecurityThreadGroup().equals(Thread.currentThread().getThreadGroup())) {
            SwingUtilities.invokeLater(runnable);
            return;
        }
        final Runnable runnable2 = new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(runnable);
            }
        };
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread thread = new Thread(Main.getSecurityThreadGroup(), runnable2);
                thread.setContextClassLoader(Main.getSecureContextClassLoader());
                thread.start();
                return null;
            }
        });
    }

    class SecureThread
    extends Thread {
        Object mutex;
        LinkedList jobList;

        SecureThread() {
            super(Main.getSecurityThreadGroup(), "Javaws Secure Thread");
            this.mutex = new Object();
            this.jobList = new LinkedList();
            this.setDaemon(true);
            this.setContextClassLoader(Main.getSecureContextClassLoader());
            this.start();
        }

        void addJob(Job job) {
            this.jobList.add(job);
        }

        private void doWork(Job job) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Thread.currentThread().setContextClassLoader(Main.getSecureContextClassLoader());
                    }
                });
                job.result = job.action.execute();
            }
            catch (Exception exception) {
                job.exception = exception;
            }
            finally {
                job.done = true;
                if (job.dialog != null) {
                    job.dialog.secureHide();
                }
            }
        }

        public void run() {
            Object object = this.mutex;
            synchronized (object) {
                while (true) {
                    if (!this.jobList.isEmpty()) {
                        Job job = (Job)this.jobList.removeFirst();
                        this.doWork(job);
                        continue;
                    }
                    this.mutex.notifyAll();
                    try {
                        this.mutex.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Trace.ignoredException((Exception)interruptedException);
                    }
                }
            }
        }
    }

    private class DummyDialog
    extends JDialog {
        private ThreadGroup _callingTG;

        DummyDialog() {
            super((Frame)null, true);
            this._callingTG = Thread.currentThread().getThreadGroup();
        }

        public void secureHide() {
            new Thread(this._callingTG, new Runnable(){

                public void run() {
                    DummyDialog.this.setVisible(false);
                }
            }).start();
        }
    }

    class Job {
        final DeploySysAction action;
        DummyDialog dialog;
        Object result;
        Exception exception;
        boolean done;

        Job(DeploySysAction deploySysAction) {
            this.action = deploySysAction;
            this.done = false;
        }

        void setDialog(DummyDialog dummyDialog) {
            this.dialog = dummyDialog;
        }
    }
}

