/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.specific;

import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.unicode.UnicodeEncoding;

public final class UTF32BEEncoding
extends UnicodeEncoding {
    public static UTF32BEEncoding INSTANCE = new UTF32BEEncoding();

    protected UTF32BEEncoding() {
        super(4, 4, (int[])null);
    }

    public String toString() {
        return "UTF-32BE";
    }

    public int length(byte c) {
        return 4;
    }

    public int length(byte[] bytes, int p2, int end2) {
        return 4;
    }

    public int strLength(byte[] bytes, int p2, int end2) {
        return end2 - p2 >>> 2;
    }

    public boolean isNewLine(byte[] bytes, int p2, int end2) {
        return p2 + 3 < end2 && bytes[p2 + 3] == 10 && bytes[p2 + 2] == 0 && bytes[p2 + 1] == 0 && bytes[p2] == 0;
    }

    public int mbcToCode(byte[] bytes, int p2, int end2) {
        return (((bytes[p2] & 0xFF) * 256 + (bytes[p2 + 1] & 0xFF)) * 256 + (bytes[p2 + 2] & 0xFF)) * 256 + (bytes[p2 + 3] & 0xFF);
    }

    public int codeToMbcLength(int code) {
        return 4;
    }

    public int codeToMbc(int code, byte[] bytes, int p2) {
        int p_ = p2;
        bytes[p_++] = (byte)((code & 0xFF000000) >>> 24);
        bytes[p_++] = (byte)((code & 0xFF0000) >>> 16);
        bytes[p_++] = (byte)((code & 0xFF00) >>> 8);
        bytes[p_++] = (byte)(code & 0xFF);
        return 4;
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end2, byte[] fold) {
        int p2 = pp.value;
        int foldP = 0;
        if (UTF32BEEncoding.isAscii(bytes[p2 + 3] & 0xFF) && bytes[p2 + 2] == 0 && bytes[p2 + 1] == 0 && bytes[p2] == 0) {
            fold[foldP++] = 0;
            fold[foldP++] = 0;
            fold[foldP++] = 0;
            fold[foldP] = AsciiTables.ToLowerCaseTable[bytes[p2 + 3] & 0xFF];
            pp.value += 4;
            return 4;
        }
        return super.mbcCaseFold(flag, bytes, pp, end2, fold);
    }

    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        sbOut.value = 0;
        return super.ctypeCodeRange(ctype);
    }

    public int leftAdjustCharHead(byte[] bytes, int p2, int s, int end2) {
        if (s <= p2) {
            return s;
        }
        return s - (s - p2) % 4;
    }

    public boolean isReverseMatchAllowed(byte[] bytes, int p2, int end2) {
        return false;
    }
}

