/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.util;

import org.jcodings.ascii.AsciiTables;
import org.jcodings.util.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CaseInsensitiveBytesHash<V>
extends Hash<V> {
    public CaseInsensitiveBytesHash() {
    }

    public CaseInsensitiveBytesHash(int size2) {
        super(size2);
    }

    @Override
    protected void init() {
        this.head = new BytesCaseInsensitiveHashEntry();
    }

    public static int hashCode(byte[] bytes, int p2, int end2) {
        int key = 0;
        while (p2 < end2) {
            key = (key << 16) + (key << 6) - key + AsciiTables.ToLowerCaseTable[bytes[p2++] & 0xFF];
        }
        key += key >> 5;
        return key;
    }

    public V put(byte[] bytes, V value2) {
        return this.put(bytes, 0, bytes.length, value2);
    }

    public V put(byte[] bytes, int p2, int end2, V value2) {
        this.checkResize();
        int hash2 = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(bytes, p2, end2));
        int i = CaseInsensitiveBytesHash.bucketIndex(hash2, this.table.length);
        BytesCaseInsensitiveHashEntry entry = (BytesCaseInsensitiveHashEntry)this.table[i];
        while (entry != null) {
            if (entry.hash == hash2 && entry.equals(bytes, p2, end2)) {
                entry.value = value2;
                return value2;
            }
            entry = (BytesCaseInsensitiveHashEntry)entry.next;
        }
        this.table[i] = new BytesCaseInsensitiveHashEntry<V>(hash2, this.table[i], value2, bytes, p2, end2, this.head);
        ++this.size;
        return null;
    }

    public void putDirect(byte[] bytes, V value2) {
        this.putDirect(bytes, 0, bytes.length, value2);
    }

    public void putDirect(byte[] bytes, int p2, int end2, V value2) {
        this.checkResize();
        int hash2 = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(bytes, p2, end2));
        int i = CaseInsensitiveBytesHash.bucketIndex(hash2, this.table.length);
        this.table[i] = new BytesCaseInsensitiveHashEntry<V>(hash2, this.table[i], value2, bytes, p2, end2, this.head);
        ++this.size;
    }

    public V get(byte[] bytes) {
        return this.get(bytes, 0, bytes.length);
    }

    public V get(byte[] bytes, int p2, int end2) {
        int hash2 = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(bytes, p2, end2));
        BytesCaseInsensitiveHashEntry entry = (BytesCaseInsensitiveHashEntry)this.table[CaseInsensitiveBytesHash.bucketIndex(hash2, this.table.length)];
        while (entry != null) {
            if (entry.hash == hash2 && entry.equals(bytes, p2, end2)) {
                return (V)entry.value;
            }
            entry = (BytesCaseInsensitiveHashEntry)entry.next;
        }
        return null;
    }

    public V delete(byte[] bytes) {
        return this.delete(bytes, 0, bytes.length);
    }

    public V delete(byte[] bytes, int p2, int end2) {
        int hash2 = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(bytes, p2, end2));
        int i = CaseInsensitiveBytesHash.bucketIndex(hash2, this.table.length);
        BytesCaseInsensitiveHashEntry entry = (BytesCaseInsensitiveHashEntry)this.table[i];
        if (entry == null) {
            return null;
        }
        if (entry.hash == hash2 && entry.equals(bytes, p2, end2)) {
            this.table[i] = entry.next;
            --this.size;
            entry.remove();
            return (V)entry.value;
        }
        while (entry.next != null) {
            Hash.HashEntry tmp = entry.next;
            if (tmp.hash == hash2 && entry.equals(bytes, p2, end2)) {
                entry.next = entry.next.next;
                --this.size;
                tmp.remove();
                return tmp.value;
            }
            entry = (BytesCaseInsensitiveHashEntry)entry.next;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BytesCaseInsensitiveHashEntry<V>
    extends Hash.HashEntry<V> {
        public final byte[] bytes;
        public final int p;
        public final int end;

        public BytesCaseInsensitiveHashEntry(int hash2, Hash.HashEntry<V> next2, V value2, byte[] bytes, int p2, int end2, Hash.HashEntry<V> head) {
            super(hash2, next2, value2, head);
            this.bytes = bytes;
            this.p = p2;
            this.end = end2;
        }

        public BytesCaseInsensitiveHashEntry() {
            this.bytes = null;
            this.end = 0;
            this.p = 0;
        }

        public boolean equals(byte[] bytes, int p2, int end2) {
            if (this.end - this.p != end2 - p2) {
                return false;
            }
            if (this.bytes == bytes) {
                return true;
            }
            int q = this.p;
            while (q < this.end) {
                if (AsciiTables.ToLowerCaseTable[this.bytes[q++] & 0xFF] == AsciiTables.ToLowerCaseTable[bytes[p2++] & 0xFF]) continue;
                return false;
            }
            return true;
        }
    }
}

