/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.WhenNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NilNode
extends Node
implements INameNode {
    public NilNode(ISourcePosition position) {
        super(position, NodeType.NILNODE);
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitNilNode(this);
    }

    @Override
    public String getName() {
        return "nil";
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return ASTInterpreter.pollAndReturn(context, runtime2.getNil());
    }

    @Override
    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        return "nil";
    }

    @Override
    public IRubyObject when(WhenNode whenNode, IRubyObject value2, ThreadContext context, Ruby runtime2, IRubyObject self, Block aBlock) {
        this.interpret(runtime2, context, self, aBlock);
        if (value2 != null && value2.isNil()) {
            return whenNode.interpret(runtime2, context, self, aBlock);
        }
        return null;
    }
}

