/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.IArityNode;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class Arity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<Integer, Arity> arities = new HashMap<Integer, Arity>();
    private final int value;
    public static final Arity NO_ARGUMENTS = Arity.newArity(0);
    public static final Arity ONE_ARGUMENT = Arity.newArity(1);
    public static final Arity TWO_ARGUMENTS = Arity.newArity(2);
    public static final Arity THREE_ARGUMENTS = Arity.newArity(3);
    public static final Arity OPTIONAL = Arity.newArity(-1);
    public static final Arity ONE_REQUIRED = Arity.newArity(-2);
    public static final Arity TWO_REQUIRED = Arity.newArity(-3);
    public static final Arity THREE_REQUIRED = Arity.newArity(-3);

    private Arity(int value2) {
        this.value = value2;
    }

    public static Arity createArity(int value2) {
        switch (value2) {
            case -4: {
                return THREE_REQUIRED;
            }
            case -3: {
                return TWO_REQUIRED;
            }
            case -2: {
                return ONE_REQUIRED;
            }
            case -1: {
                return OPTIONAL;
            }
            case 0: {
                return NO_ARGUMENTS;
            }
            case 1: {
                return ONE_ARGUMENT;
            }
            case 2: {
                return TWO_ARGUMENTS;
            }
            case 3: {
                return THREE_ARGUMENTS;
            }
        }
        return Arity.newArity(value2);
    }

    public static Arity fromAnnotation(JRubyMethod anno) {
        if (anno.optional() > 0 || anno.rest()) {
            return Arity.createArity(-(anno.required() + 1));
        }
        return Arity.createArity(anno.required());
    }

    public static Arity fromAnnotation(JRubyMethod anno, int actualRequired) {
        if (anno.optional() > 0 || anno.rest()) {
            return Arity.createArity(-(actualRequired + 1));
        }
        return Arity.createArity(actualRequired);
    }

    public static Arity fromAnnotation(JRubyMethod anno, Class[] parameterTypes, boolean isStatic) {
        int required = 0;
        if (anno.optional() == 0 && !anno.rest() && anno.required() == 0) {
            int i = parameterTypes.length;
            if (isStatic) {
                --i;
            }
            if (parameterTypes.length > 0) {
                if (parameterTypes[0] == ThreadContext.class) {
                    --i;
                }
                if (parameterTypes[parameterTypes.length - 1] == Block.class) {
                    --i;
                }
            }
            required = i;
        } else {
            required = anno.required();
        }
        if (anno.optional() > 0 || anno.rest()) {
            return Arity.createArity(-(required + 1));
        }
        return Arity.createArity(required);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Arity newArity(int value2) {
        Arity result;
        Integer integerValue = new Integer(value2);
        Map<Integer, Arity> map = arities;
        synchronized (map) {
            result = arities.get(integerValue);
            if (result == null) {
                result = new Arity(value2);
                arities.put(integerValue, result);
            }
        }
        return result;
    }

    public static Arity fixed(int arity2) {
        assert (arity2 >= 0);
        return Arity.createArity(arity2);
    }

    public static Arity optional() {
        return OPTIONAL;
    }

    public static Arity required(int minimum) {
        assert (minimum >= 0);
        return Arity.createArity(-(1 + minimum));
    }

    public static Arity noArguments() {
        return NO_ARGUMENTS;
    }

    public static Arity singleArgument() {
        return ONE_ARGUMENT;
    }

    public static Arity twoArguments() {
        return TWO_ARGUMENTS;
    }

    public static Arity procArityOf(Node node) {
        if (node instanceof AttrAssignNode && node != null) {
            node = ((AttrAssignNode)node).getArgsNode();
        }
        if (node == null) {
            return Arity.optional();
        }
        if (node instanceof IArityNode) {
            return ((IArityNode)((Object)node)).getArity();
        }
        if (node instanceof CallNode) {
            return Arity.singleArgument();
        }
        if (node instanceof ArrayNode) {
            return Arity.singleArgument();
        }
        throw new Error("unexpected type " + node.getClass() + " at " + node.getPosition());
    }

    public int getValue() {
        return this.value;
    }

    public void checkArity(Ruby runtime2, IRubyObject[] args2) {
        if (this.isFixed() ? args2.length != this.required() : args2.length < this.required()) {
            throw runtime2.newArgumentError("wrong number of arguments(" + args2.length + " for " + this.required() + ")");
        }
    }

    public void checkArity(Ruby runtime2, int length2) {
        if (this.isFixed() ? length2 != this.required() : length2 < this.required()) {
            throw runtime2.newArgumentError("wrong number of arguments(" + length2 + " for " + this.required() + ")");
        }
    }

    public boolean isFixed() {
        return this.value >= 0;
    }

    public int required() {
        if (this.value < 0) {
            return -(1 + this.value);
        }
        return this.value;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        if (this.isFixed()) {
            return "Fixed" + this.required();
        }
        return "Opt";
    }

    public static int checkArgumentCount(Ruby runtime2, IRubyObject[] args2, int min2, int max2) {
        return Arity.checkArgumentCount(runtime2, args2.length, min2, max2);
    }

    public static int checkArgumentCount(Ruby runtime2, int length2, int min2, int max2) {
        int expected = 0;
        if (length2 < min2) {
            expected = min2;
        } else if (max2 > -1 && length2 > max2) {
            expected = max2;
        } else {
            return length2;
        }
        throw runtime2.newArgumentError(length2, expected);
    }

    public static void raiseArgumentError(Ruby runtime2, int length2, int min2, int max2) {
        if (length2 < min2) {
            throw runtime2.newArgumentError(length2, min2);
        }
        if (max2 > -1 && length2 > max2) {
            throw runtime2.newArgumentError(length2, max2);
        }
    }

    public static IRubyObject[] scanArgs(Ruby runtime2, IRubyObject[] args2, int required, int optional) {
        int total2 = required + optional;
        int real2 = Arity.checkArgumentCount(runtime2, args2, required, total2);
        IRubyObject[] narr = new IRubyObject[total2];
        System.arraycopy(args2, 0, narr, 0, real2);
        for (int i = real2; i < total2; ++i) {
            narr[i] = runtime2.getNil();
        }
        return narr;
    }
}

