/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jruby.IncludedModuleWrapper;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.runtime.marshal.MarshalCache;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshalStream
extends FilterOutputStream {
    private final Ruby runtime;
    private final MarshalCache cache;
    private final int depthLimit;
    private int depth = 0;
    private static final char TYPE_IVAR = 'I';
    private static final char TYPE_USRMARSHAL = 'U';
    private static final char TYPE_USERDEF = 'u';
    private static final char TYPE_UCLASS = 'C';

    public MarshalStream(Ruby runtime2, OutputStream out, int depthLimit) throws IOException {
        super(out);
        this.runtime = runtime2;
        this.depthLimit = depthLimit >= 0 ? depthLimit : Integer.MAX_VALUE;
        this.cache = new MarshalCache();
        out.write(4);
        out.write(8);
    }

    public void dumpObject(IRubyObject value2) throws IOException {
        ++this.depth;
        if (this.depth > this.depthLimit) {
            throw this.runtime.newArgumentError("exceed depth limit");
        }
        this.writeAndRegister(value2);
        --this.depth;
        if (this.depth == 0) {
            this.out.flush();
        }
    }

    public void registerLinkTarget(IRubyObject newObject) {
        if (MarshalStream.shouldBeRegistered(newObject)) {
            this.cache.register(newObject);
        }
    }

    static boolean shouldBeRegistered(IRubyObject value2) {
        if (value2.isNil()) {
            return false;
        }
        if (value2 instanceof RubyBoolean) {
            return false;
        }
        if (value2 instanceof RubyFixnum) {
            return !MarshalStream.isMarshalFixnum((RubyFixnum)value2);
        }
        return true;
    }

    private static boolean isMarshalFixnum(RubyFixnum fixnum) {
        return fixnum.getLongValue() <= 0x3FFFFFFFL && fixnum.getLongValue() >= -1073741824L;
    }

    private void writeAndRegister(IRubyObject value2) throws IOException {
        if (this.cache.isRegistered(value2)) {
            this.cache.writeLink(this, value2);
        } else if (this.hasNewUserDefinedMarshaling(value2)) {
            this.userNewMarshal(value2);
        } else if (this.hasUserDefinedMarshaling(value2)) {
            this.userMarshal(value2);
        } else {
            this.writeDirectly(value2);
        }
    }

    private List<Variable<IRubyObject>> getVariables(IRubyObject value2) throws IOException {
        int nativeTypeIndex;
        List<Variable<IRubyObject>> variables = null;
        if (value2 instanceof CoreObjectType && (nativeTypeIndex = ((CoreObjectType)((Object)value2)).getNativeTypeIndex()) != 14) {
            if (!value2.isImmediate() && value2.hasVariables() && nativeTypeIndex != 13 && nativeTypeIndex != 12) {
                variables = value2.getVariableList();
                this.write(73);
            }
            RubyClass type2 = value2.getMetaClass();
            switch (nativeTypeIndex) {
                case 3: 
                case 4: 
                case 9: 
                case 10: {
                    type2 = this.dumpExtended(type2);
                }
            }
            if (nativeTypeIndex != value2.getMetaClass().index && nativeTypeIndex != 15) {
                this.writeUserClass(value2, type2);
            }
        }
        return variables;
    }

    private void writeDirectly(IRubyObject value2) throws IOException {
        List<Variable<IRubyObject>> variables = this.getVariables(value2);
        this.writeObjectData(value2);
        if (variables != null) {
            this.dumpVariables(variables);
        }
    }

    public static String getPathFromClass(RubyModule clazz) {
        RubyModule real2;
        String path2 = clazz.getName();
        if (path2.charAt(0) == '#') {
            String classOrModule = clazz.isClass() ? "class" : "module";
            throw clazz.getRuntime().newTypeError("can't dump anonymous " + classOrModule + " " + path2);
        }
        RubyModule rubyModule = real2 = clazz.isModule() ? clazz : ((RubyClass)clazz).getRealClass();
        if (clazz.getRuntime().getClassFromPath(path2) != real2) {
            throw clazz.getRuntime().newTypeError(path2 + " can't be referred");
        }
        return path2;
    }

    private void writeObjectData(IRubyObject value2) throws IOException {
        if (value2 instanceof CoreObjectType) {
            int nativeTypeIndex = ((CoreObjectType)((Object)value2)).getNativeTypeIndex();
            switch (nativeTypeIndex) {
                case 3: {
                    this.write(91);
                    RubyArray.marshalTo((RubyArray)value2, this);
                    return;
                }
                case 7: {
                    this.write(70);
                    return;
                }
                case 1: {
                    RubyFixnum fixnum = (RubyFixnum)value2;
                    if (MarshalStream.isMarshalFixnum(fixnum)) {
                        this.write(105);
                        this.writeInt((int)fixnum.getLongValue());
                        return;
                    }
                    value2 = RubyBignum.newBignum(value2.getRuntime(), fixnum.getLongValue());
                }
                case 2: {
                    this.write(108);
                    RubyBignum.marshalTo((RubyBignum)value2, this);
                    return;
                }
                case 13: {
                    if (((RubyClass)value2).isSingleton()) {
                        throw this.runtime.newTypeError("singleton class can't be dumped");
                    }
                    this.write(99);
                    RubyClass.marshalTo((RubyClass)value2, this);
                    return;
                }
                case 11: {
                    this.write(102);
                    RubyFloat.marshalTo((RubyFloat)value2, this);
                    return;
                }
                case 10: {
                    RubyHash hash2 = (RubyHash)value2;
                    if (hash2.getIfNone().isNil()) {
                        this.write(123);
                    } else {
                        if (hash2.hasDefaultProc()) {
                            throw hash2.getRuntime().newTypeError("can't dump hash with default proc");
                        }
                        this.write(125);
                    }
                    RubyHash.marshalTo(hash2, this);
                    return;
                }
                case 12: {
                    this.write(109);
                    RubyModule.marshalTo((RubyModule)value2, this);
                    return;
                }
                case 5: {
                    this.write(48);
                    return;
                }
                case 14: {
                    this.dumpDefaultObjectHeader(value2.getMetaClass());
                    value2.getMetaClass().getRealClass().marshal(value2, this);
                    return;
                }
                case 9: {
                    this.write(47);
                    RubyRegexp.marshalTo((RubyRegexp)value2, this);
                    return;
                }
                case 4: {
                    this.registerLinkTarget(value2);
                    this.write(34);
                    this.writeString(value2.convertToString().getByteList());
                    return;
                }
                case 15: {
                    RubyStruct.marshalTo((RubyStruct)value2, this);
                    return;
                }
                case 8: {
                    this.registerLinkTarget(value2);
                    this.write(58);
                    this.writeString(value2.toString());
                    return;
                }
                case 6: {
                    this.write(84);
                    return;
                }
            }
        } else {
            this.dumpDefaultObjectHeader(value2.getMetaClass());
            value2.getMetaClass().getRealClass().marshal(value2, this);
        }
    }

    private boolean hasNewUserDefinedMarshaling(IRubyObject value2) {
        return value2.respondsTo("marshal_dump");
    }

    private void userNewMarshal(IRubyObject value2) throws IOException {
        this.registerLinkTarget(value2);
        this.write(85);
        RubyClass metaclass = value2.getMetaClass().getRealClass();
        this.dumpObject(RubySymbol.newSymbol(this.runtime, metaclass.getName()));
        IRubyObject marshaled = value2.callMethod(this.runtime.getCurrentContext(), "marshal_dump");
        this.dumpObject(marshaled);
    }

    private boolean hasUserDefinedMarshaling(IRubyObject value2) {
        return value2.respondsTo("_dump");
    }

    private void userMarshal(IRubyObject value2) throws IOException {
        this.registerLinkTarget(value2);
        IRubyObject dumpResult = value2.callMethod(this.runtime.getCurrentContext(), "_dump", this.runtime.newFixnum(this.depthLimit));
        if (!(dumpResult instanceof RubyString)) {
            throw this.runtime.newTypeError(dumpResult, this.runtime.getString());
        }
        RubyString marshaled = (RubyString)dumpResult;
        boolean hasVars = marshaled.hasVariables();
        if (hasVars) {
            this.write(73);
        }
        this.write(117);
        RubyClass metaclass = value2.getMetaClass().getRealClass();
        this.dumpObject(RubySymbol.newSymbol(this.runtime, metaclass.getName()));
        this.writeString(marshaled.getByteList());
        if (hasVars) {
            this.dumpVariables(marshaled.getVariableList());
        }
    }

    public void writeUserClass(IRubyObject obj, RubyClass type2) throws IOException {
        this.write(67);
        if (type2.getName().charAt(0) == '#') {
            throw obj.getRuntime().newTypeError("can't dump anonymous class " + type2.getName());
        }
        this.dumpObject(this.runtime.newSymbol(type2.getName()));
    }

    public void dumpInstanceVars(Map instanceVars) throws IOException {
        this.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "internal: deprecated dumpInstanceVars() called", "dumpInstanceVars");
        this.writeInt(instanceVars.size());
        for (String name2 : instanceVars.keySet()) {
            IRubyObject value2 = (IRubyObject)instanceVars.get(name2);
            this.writeAndRegister(this.runtime.newSymbol(name2));
            this.dumpObject(value2);
        }
    }

    public void dumpVariables(List<Variable<IRubyObject>> vars) throws IOException {
        this.writeInt(vars.size());
        for (Variable<IRubyObject> var : vars) {
            this.writeAndRegister(this.runtime.newSymbol(var.getName()));
            this.dumpObject(var.getValue());
        }
    }

    private boolean hasSingletonMethods(RubyClass type2) {
        for (Map.Entry<String, DynamicMethod> entry : type2.getMethods().entrySet()) {
            DynamicMethod method2 = entry.getValue();
            if (method2.getImplementationClass() != type2) continue;
            return true;
        }
        return false;
    }

    private RubyClass dumpExtended(RubyClass type2) throws IOException {
        if (type2.isSingleton()) {
            if (this.hasSingletonMethods(type2) || type2.hasVariables()) {
                throw type2.getRuntime().newTypeError("singleton can't be dumped");
            }
            type2 = type2.getSuperClass();
        }
        while (type2.isIncluded()) {
            this.write(101);
            this.dumpObject(RubySymbol.newSymbol(this.runtime, ((IncludedModuleWrapper)type2).getNonIncludedClass().getName()));
            type2 = type2.getSuperClass();
        }
        return type2;
    }

    public void dumpDefaultObjectHeader(RubyClass type2) throws IOException {
        this.dumpDefaultObjectHeader('o', type2);
    }

    public void dumpDefaultObjectHeader(char tp, RubyClass type2) throws IOException {
        this.dumpExtended(type2);
        this.write(tp);
        RubySymbol classname = RubySymbol.newSymbol(this.runtime, MarshalStream.getPathFromClass(type2.getRealClass()));
        this.dumpObject(classname);
    }

    public void writeString(String value2) throws IOException {
        this.writeInt(value2.length());
        this.out.write(RubyString.stringToBytes(value2));
    }

    public void writeString(ByteList value2) throws IOException {
        int len = value2.length();
        this.writeInt(len);
        this.out.write(value2.unsafeBytes(), value2.begin(), len);
    }

    public void dumpSymbol(String value2) throws IOException {
        this.write(58);
        this.writeInt(value2.length());
        this.out.write(RubyString.stringToBytes(value2));
    }

    public void writeInt(int value2) throws IOException {
        if (value2 == 0) {
            this.out.write(0);
        } else if (0 < value2 && value2 < 123) {
            this.out.write(value2 + 5);
        } else if (-124 < value2 && value2 < 0) {
            this.out.write(value2 - 5 & 0xFF);
        } else {
            int i;
            byte[] buf = new byte[4];
            for (i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(value2 & 0xFF);
                if ((value2 >>= 8) == 0 || value2 == -1) break;
            }
            int len = i + 1;
            this.out.write(value2 < 0 ? -len : len);
            this.out.write(buf, 0, i + 1);
        }
    }
}

