/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.byteman.agent.Location;
import org.jboss.byteman.agent.LocationType;
import org.jboss.byteman.agent.RuleScript;

public class ScriptRepository {
    private final Map<String, List<RuleScript>> targetClassIndex = new HashMap<String, List<RuleScript>>();
    private final Map<String, List<RuleScript>> targetInterfaceIndex = new HashMap<String, List<RuleScript>>();
    private final Map<String, RuleScript> ruleNameIndex = new HashMap<String, RuleScript>();
    private final boolean skipOverrideRules;
    private int overrideRuleCount = 0;

    public ScriptRepository(boolean skipOverrideRules) {
        this.skipOverrideRules = skipOverrideRules;
    }

    public List<RuleScript> processScripts(String scriptText, String scriptFile) throws Exception {
        LinkedList<RuleScript> ruleScripts = new LinkedList<RuleScript>();
        if (scriptText != null) {
            String[] lines = scriptText.split("\n");
            ArrayList rules = new ArrayList();
            String nextRule = "";
            String sepr = "";
            String name = null;
            String targetClass = null;
            String targetMethod = null;
            String targetHelper = null;
            String defaultHelper = null;
            String[] targetImports = null;
            String[] defaultImports = new String[]{};
            LocationType locationType = null;
            Location targetLocation = null;
            boolean isInterface = false;
            boolean isOverride = false;
            int lineNumber = 0;
            int startNumber = -1;
            int maxLines = lines.length;
            boolean inRule = false;
            for (String line : lines) {
                line = line.trim();
                ++lineNumber;
                if (line.startsWith("#")) {
                    if (!inRule) continue;
                    nextRule = nextRule + sepr;
                    sepr = "\n";
                    continue;
                }
                if (line.startsWith("RULE ")) {
                    inRule = true;
                    name = line.substring(5).trim();
                    if (!name.equals("")) continue;
                    throw new Exception("org.jboss.byteman.agent.Transformer : RULE with no name at line " + lineNumber + " in script " + scriptFile);
                }
                if (line.startsWith("HELPER ")) {
                    if (inRule) {
                        targetHelper = line.substring(7).trim();
                        continue;
                    }
                    defaultHelper = line.substring(7).trim();
                    if (defaultHelper.length() != 0) continue;
                    defaultHelper = null;
                    continue;
                }
                if (line.startsWith("IMPORT ")) {
                    String imp = line.substring(7).trim();
                    if (inRule) {
                        targetImports = targetImports == null ? new String[1] : Arrays.copyOf(targetImports, targetImports.length + 1);
                        targetImports[targetImports.length - 1] = imp;
                        continue;
                    }
                    defaultImports = defaultImports == null ? new String[1] : Arrays.copyOf(defaultImports, defaultImports.length + 1);
                    defaultImports[defaultImports.length - 1] = imp;
                    continue;
                }
                if (!inRule) {
                    if (line.equals("")) continue;
                    throw new Exception("org.jboss.byteman.agent.Transformer : invalid text outside of RULE/ENDRULE at line " + lineNumber + " in script " + scriptFile);
                }
                if (line.startsWith("CLASS ")) {
                    targetClass = line.substring(6).trim();
                    if (!targetClass.startsWith("^")) continue;
                    isOverride = true;
                    targetClass = targetClass.substring(1).trim();
                    continue;
                }
                if (line.startsWith("INTERFACE ")) {
                    targetClass = line.substring(10).trim();
                    isInterface = true;
                    if (!targetClass.startsWith("^")) continue;
                    isOverride = true;
                    targetClass = targetClass.substring(1).trim();
                    continue;
                }
                if (line.startsWith("METHOD ")) {
                    targetMethod = line.substring(7).trim();
                    continue;
                }
                locationType = LocationType.type(line);
                if (locationType != null) {
                    String parameters = LocationType.parameterText(line);
                    targetLocation = Location.create(locationType, parameters);
                    if (targetLocation != null) continue;
                    throw new Exception("org.jboss.byteman.agent.Transformer : invalid target location at line " + lineNumber + " in script " + scriptFile);
                }
                if (line.startsWith("ENDRULE")) {
                    if (name == null || "".equals(name)) {
                        throw new Exception("org.jboss.byteman.agent.Transformer : no matching RULE for ENDRULE at line " + lineNumber + " in script " + scriptFile);
                    }
                    if (targetClass == null || "".equals(targetClass)) {
                        throw new Exception("org.jboss.byteman.agent.Transformer : no CLASS for RULE  " + name + " in script " + scriptFile);
                    }
                    if (targetMethod == null || "".equals(targetMethod)) {
                        throw new Exception("org.jboss.byteman.agent.Transformer : no METHOD for RULE  " + name + " in script " + scriptFile);
                    }
                    if (targetLocation == null) {
                        targetLocation = Location.create(LocationType.ENTRY, "");
                    }
                    if (targetHelper == null) {
                        targetHelper = defaultHelper;
                    }
                    if (targetImports == null) {
                        targetImports = defaultImports;
                    }
                    RuleScript ruleScript = new RuleScript(name, targetClass, isInterface, isOverride, targetMethod, targetHelper, targetImports, targetLocation, nextRule, startNumber, scriptFile);
                    ruleScripts.add(ruleScript);
                    name = null;
                    targetClass = null;
                    targetMethod = null;
                    targetLocation = null;
                    targetHelper = null;
                    targetImports = null;
                    nextRule = "";
                    sepr = "";
                    inRule = false;
                    isInterface = false;
                    startNumber = -1;
                    continue;
                }
                if (lineNumber == maxLines && !nextRule.trim().equals("")) {
                    throw new Exception("org.jboss.byteman.agent.Transformer : no matching ENDRULE for RULE " + name + " in script " + scriptFile);
                }
                if (startNumber < 0) {
                    startNumber = lineNumber;
                }
                nextRule = nextRule + sepr + line;
                sepr = "\n";
            }
        }
        return ruleScripts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleScript addScript(RuleScript script) {
        String name = script.getName();
        RuleScript previous = null;
        if (this.skipOverrideRules && script.isOverride()) {
            System.err.println("ScriptRepository.addScript : injection into overriding methods disabled but found override rule " + script.getName());
        }
        Map<String, RuleScript> map = this.ruleNameIndex;
        synchronized (map) {
            boolean isDeleted;
            previous = this.ruleNameIndex.put(name, script);
            if (previous != null && (isDeleted = previous.setDeleted())) {
                previous = null;
            }
        }
        boolean isOverride = script.isOverride();
        if (previous == null) {
            if (isOverride) {
                ++this.overrideRuleCount;
            }
            if (script.isInterface()) {
                this.indexTarget(script, this.targetInterfaceIndex);
            } else {
                this.indexTarget(script, this.targetClassIndex);
            }
        } else {
            boolean wasInterface;
            boolean isInterface;
            boolean wasOverride = previous.isOverride();
            if (isOverride) {
                ++this.overrideRuleCount;
            }
            if ((isInterface = script.isInterface()) == (wasInterface = previous.isInterface())) {
                Map<String, List<RuleScript>> index = isInterface ? this.targetInterfaceIndex : this.targetClassIndex;
                this.reindexTarget(script, previous, index);
            } else if (isInterface) {
                this.unindexTarget(previous, this.targetClassIndex);
                this.indexTarget(script, this.targetInterfaceIndex);
            } else {
                this.unindexTarget(previous, this.targetInterfaceIndex);
                this.indexTarget(script, this.targetClassIndex);
            }
            if (wasOverride) {
                --this.overrideRuleCount;
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleScript removeScript(RuleScript script) {
        RuleScript current;
        String name = script.getName();
        Map<String, RuleScript> map = this.ruleNameIndex;
        synchronized (map) {
            current = this.ruleNameIndex.get(name);
            if (current == script) {
                this.ruleNameIndex.remove(current.getName());
                boolean isDeleted = current.setDeleted();
                if (isDeleted) {
                    current = null;
                }
            } else {
                current = null;
            }
        }
        if (current != null) {
            Map<String, List<RuleScript>> index = current.isInterface() ? this.targetInterfaceIndex : this.targetClassIndex;
            this.unindexTarget(current, index);
            boolean wasOverride = current.isOverride();
            if (wasOverride) {
                --this.overrideRuleCount;
            }
        }
        return current;
    }

    public RuleScript removeScript(String name) {
        RuleScript current = this.scriptForRuleName(name);
        if (current != null) {
            current = this.removeScript(current);
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleScript scriptForRuleName(String name) {
        Map<String, RuleScript> map = this.ruleNameIndex;
        synchronized (map) {
            return this.ruleNameIndex.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RuleScript> scriptsForClassName(String name) {
        Map<String, List<RuleScript>> map = this.targetClassIndex;
        synchronized (map) {
            return this.targetClassIndex.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RuleScript> scriptsForInterfaceName(String name) {
        Map<String, List<RuleScript>> map = this.targetInterfaceIndex;
        synchronized (map) {
            return this.targetInterfaceIndex.get(name);
        }
    }

    public boolean matchClass(Class<?> clazz) throws Exception {
        boolean isOverride = false;
        LinkedList visited = null;
        LinkedList toVisit = null;
        for (Class<?> nextClazz = clazz; nextClazz != null; nextClazz = nextClazz.getSuperclass()) {
            Class<?>[] interfaces;
            int l;
            String name = nextClazz.getName();
            if (this.matchTarget(name, clazz, false, isOverride)) {
                return true;
            }
            int lastDot = name.lastIndexOf(46);
            if (lastDot >= 0 && this.matchTarget(name.substring(lastDot + 1), clazz, false, isOverride)) {
                return true;
            }
            if (this.checkInterfaces() && (l = (interfaces = nextClazz.getInterfaces()).length) > 0) {
                if (visited == null) {
                    visited = new LinkedList();
                    toVisit = new LinkedList();
                }
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> interfaze = interfaces[i];
                    if (visited.contains(interfaze)) continue;
                    toVisit.add(interfaze);
                }
                while (!toVisit.isEmpty()) {
                    Class<?> interfaze = (Class<?>)toVisit.pop();
                    name = interfaze.getName();
                    if (this.matchTarget(name, clazz, true, isOverride)) {
                        return true;
                    }
                    lastDot = name.lastIndexOf(46);
                    if (lastDot >= 0 && this.matchTarget(name.substring(lastDot + 1), clazz, true, isOverride)) {
                        return true;
                    }
                    visited.add(interfaze);
                    interfaces = interfaze.getInterfaces();
                    for (int i = 0; i < interfaces.length; ++i) {
                        interfaze = interfaces[i];
                        if (visited.contains(interfaze)) continue;
                        toVisit.add(interfaze);
                    }
                }
            }
            if (this.skipOverrideRules) {
                return false;
            }
            isOverride = true;
        }
        return false;
    }

    public List<RuleScript> currentRules() {
        return new ArrayList<RuleScript>(this.ruleNameIndex.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchTarget(String name, Class<?> clazz, boolean isInterface, boolean isOverride) {
        Map<String, List<RuleScript>> index;
        Map<String, List<RuleScript>> map = index = isInterface ? this.targetInterfaceIndex : this.targetClassIndex;
        synchronized (map) {
            List<RuleScript> ruleScripts = index.get(name);
            if (ruleScripts != null) {
                for (RuleScript ruleScript : ruleScripts) {
                    int wsPos;
                    if (isOverride && !ruleScript.isOverride()) continue;
                    String methodName = ruleScript.getTargetMethod();
                    int signaturePos = methodName.indexOf("(");
                    if (signaturePos > 0) {
                        methodName = methodName.substring(0, signaturePos).trim();
                    }
                    if ((wsPos = methodName.indexOf(32)) < 0) {
                        wsPos = methodName.indexOf(9);
                    }
                    if (wsPos > 0) {
                        methodName = methodName.substring(wsPos).trim();
                    }
                    if ("<init>".equals(methodName) || "<clinit>".equals(methodName)) {
                        return true;
                    }
                    try {
                        Method[] declaredMethods = clazz.getDeclaredMethods();
                        for (int i = 0; i < declaredMethods.length; ++i) {
                            Method method = declaredMethods[i];
                            if (!method.getName().equals(methodName)) continue;
                            return true;
                        }
                    }
                    catch (NoClassDefFoundError e) {
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexTarget(RuleScript script, Map<String, List<RuleScript>> index) {
        String key = script.getTargetClass();
        RuleScript ruleScript = script;
        synchronized (ruleScript) {
            if (script.isDeleted()) {
                return;
            }
            Map<String, List<RuleScript>> map = index;
            synchronized (map) {
                List<RuleScript> entry = index.get(key);
                if (entry == null) {
                    entry = new ArrayList<RuleScript>();
                    this.add(entry, script);
                } else {
                    entry = new ArrayList<RuleScript>(entry);
                    this.add(entry, script);
                }
                index.put(key, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unindexTarget(RuleScript script, Map<String, List<RuleScript>> index) {
        Map<String, List<RuleScript>> map = index;
        synchronized (map) {
            String key = script.getTargetClass();
            List<RuleScript> entry = index.get(key);
            if (entry != null && entry.contains(script)) {
                if (entry.size() == 1) {
                    entry = null;
                } else {
                    entry = new ArrayList<RuleScript>(entry);
                    entry.remove(script);
                }
                index.put(key, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindexTarget(RuleScript script, RuleScript previous, Map<String, List<RuleScript>> index) {
        RuleScript ruleScript = script;
        synchronized (ruleScript) {
            if (script.isDeleted()) {
                this.unindexTarget(previous, index);
                return;
            }
            String key = script.getTargetClass();
            String oldKey = previous.getTargetClass();
            Map<String, List<RuleScript>> map = index;
            synchronized (map) {
                if (key == oldKey) {
                    List<RuleScript> entry = index.get(key);
                    if (entry == null || !entry.contains(previous)) {
                        entry = new ArrayList<RuleScript>(entry);
                        this.add(entry, script);
                    } else {
                        entry = new ArrayList<RuleScript>(entry);
                        entry.remove(previous);
                        this.add(entry, script);
                    }
                    index.put(key, entry);
                } else {
                    List<RuleScript> entry = index.get(oldKey);
                    if (entry != null && entry.contains(previous)) {
                        if (entry.size() == 1) {
                            entry = null;
                        } else {
                            entry = new ArrayList<RuleScript>(entry);
                            entry.remove(previous);
                        }
                        index.put(oldKey, entry);
                    }
                    entry = (entry = index.get(key)) == null ? new ArrayList<RuleScript>() : new ArrayList<RuleScript>(entry);
                    this.add(entry, script);
                    index.put(key, entry);
                }
            }
        }
    }

    private void add(List<RuleScript> entries, RuleScript script) {
        if (script.getTargetLocation().getLocationType() == LocationType.ENTRY) {
            entries.add(0, script);
        } else {
            entries.add(script);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkInterfaces() {
        Map<String, List<RuleScript>> map = this.targetInterfaceIndex;
        synchronized (map) {
            return !this.targetInterfaceIndex.isEmpty();
        }
    }

    public boolean skipOverrideRules() {
        if (this.skipOverrideRules) {
            return true;
        }
        return this.overrideRuleCount == 0;
    }
}

