/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.byteman.agent.BytemanPolicy;
import org.jboss.byteman.agent.HelperManager;
import org.jboss.byteman.agent.RuleScript;
import org.jboss.byteman.agent.ScriptRepository;
import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.check.BytecodeChecker;
import org.jboss.byteman.agent.check.ClassChecker;
import org.jboss.byteman.agent.check.LoadCache;
import org.jboss.byteman.agent.check.LoadedClassChecker;
import org.jboss.byteman.modules.ModuleSystem;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.type.TypeHelper;

public class Transformer
implements ClassFileTransformer {
    public static final String BYTEMAN_PACKAGE_PREFIX = "org.jboss.byteman.";
    public static final String BYTEMAN_TEST_PACKAGE_PREFIX = "org.jboss.byteman.tests.";
    public static final String BYTEMAN_SAMPLE_PACKAGE_PREFIX = "org.jboss.byteman.sample.";
    public static final String JAVA_LANG_PACKAGE_PREFIX = "java.lang.";
    public static final String VERBOSE = "org.jboss.byteman.verbose";
    public static final String DUMP_CFG_PARTIAL = "org.jboss.byteman.dump.cfg.partial";
    public static final String DUMP_CFG = "org.jboss.byteman.dump.cfg";
    public static final String DEBUG = "org.jboss.byteman.debug";
    public static final String COMPILE_TO_BYTECODE_COMPATIBILITY = "org.jboss.byteman.compileToBytecode";
    public static final String COMPILE_TO_BYTECODE = "org.jboss.byteman.compile.to.bytecode";
    public static final String DUMP_GENERATED_CLASSES = "org.jboss.byteman.dump.generated.classes";
    public static final String DUMP_GENERATED_CLASSES_INTERMEDIATE = "org.jboss.byteman.dump.generated.classes.intermediate";
    public static final String DUMP_GENERATED_CLASSES_DIR = "org.jboss.byteman.dump.generated.classes.directory";
    public static final String TRANSFORM_ALL = "org.jboss.byteman.transform.all";
    public static final String TRANSFORM_ALL_COMPATIBILITY = "org.jboss.byteman.quodlibet";
    public static final String SKIP_OVERRIDE_RULES = "org.jboss.byteman.skip.override.rules";
    public static final String SYSPROPS_STRICT_MODE = "org.jboss.byteman.sysprops.strict";
    public static final String VERIFY_TRANSFORMED_BYTES = "org.jboss.byteman.verify.transformed.bytes";
    public static final String ALLOW_CONFIG_UPDATE = "org.jboss.byteman.allow.config.update";
    public static final String DISALLOW_DOWNCAST = "org.jboss.byteman.disallow.downcast";
    private HashSet<String> blacklisted = this.initBlackList();
    protected final Instrumentation inst;
    protected boolean isRedefine;
    protected final ScriptRepository scriptRepository;
    protected final LoadCache loadCache;
    protected final HelperManager helperManager;
    private static boolean verbose = Transformer.computeVerbose();
    private static boolean dumpCFGPartial = Transformer.computeDumpCFGPartial();
    private static boolean dumpCFG = Transformer.computeDumpCFG();
    private static boolean debug = Transformer.computeDebug();
    private static boolean compileToBytecode = Transformer.computeCompileToBytecode();
    private static boolean skipOverrideRules = Transformer.computeSkipOverrideRules();
    private static boolean dumpGeneratedClasses = Transformer.computeDumpGeneratedClasses();
    private static boolean dumpGeneratedClassesIntermediate = Transformer.computeDumpGeneratedClassesIntermediate();
    private static String dumpGeneratedClassesDir = Transformer.computeDumpGeneratedClassesDir();
    private static boolean transformAll = Transformer.computeTransformAll();
    private static boolean verifyTransformedBytes = Transformer.computeVerifyTransformedBytes();
    private static boolean disallowDowncast = Transformer.computeDisallowDowncast();
    private static boolean allowConfigUpdate = System.getProperty("org.jboss.byteman.allow.config.update") != null;
    private static Object configLock = new Object();
    private static ThreadLocal<Integer> isEnabled = new ThreadLocal();
    private static final Integer DISABLED_USER = new Integer(0);
    private static final Integer DISABLED = new Integer(1);
    private static final Integer ENABLED = null;

    public Transformer(Instrumentation inst, ModuleSystem moduleSystem, List<String> scriptPaths, List<String> scriptTexts, boolean isRedefine) throws Exception {
        this.inst = inst;
        this.isRedefine = isRedefine;
        this.scriptRepository = new ScriptRepository(skipOverrideRules);
        this.loadCache = new LoadCache(inst);
        this.helperManager = new HelperManager(inst, moduleSystem);
        Iterator<String> scriptsIter = scriptTexts.iterator();
        Iterator<String> filesIter = scriptPaths.iterator();
        while (scriptsIter.hasNext()) {
            String scriptText = scriptsIter.next();
            String file = filesIter.next();
            List<RuleScript> ruleScripts = this.scriptRepository.processScripts(scriptText, file);
            for (RuleScript ruleScript : ruleScripts) {
                String name = ruleScript.getName();
                RuleScript previous = this.scriptRepository.scriptForRuleName(name);
                if (previous == null) {
                    this.scriptRepository.addScript(ruleScript);
                    continue;
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("Transformer : duplicate script name ");
                buffer.append(name);
                buffer.append("in file ");
                buffer.append(ruleScript.getFile());
                buffer.append("  line ");
                buffer.append(ruleScript.getLine());
                buffer.append("\n previously defined in file ");
                buffer.append(previous.getFile());
                buffer.append("  line ");
                buffer.append(previous.getLine());
                Exception ex = new Exception(buffer.toString());
                throw ex;
            }
        }
    }

    public void installBootScripts() throws Exception {
        Class[] loaded;
        LinkedList<Class> transformed = new LinkedList<Class>();
        for (Class clazz : loaded = this.inst.getAllLoadedClasses()) {
            if (this.isSkipClass(clazz) || !this.scriptRepository.matchClass(clazz)) continue;
            transformed.add(clazz);
        }
        if (!transformed.isEmpty()) {
            Class[] transformedArray = new Class[transformed.size()];
            transformed.toArray(transformedArray);
            if (Transformer.isVerbose()) {
                for (int i = 0; i < transformed.size(); ++i) {
                    System.out.println("retransforming " + transformedArray[i].getName());
                }
            }
            this.inst.retransformClasses(transformedArray);
        }
    }

    public void installPolicy() {
        BytemanPolicy policy = new BytemanPolicy(Policy.getPolicy());
        Policy.setPolicy(policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader originalLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        boolean enabled = true;
        ClassLoader loader = originalLoader;
        try {
            enabled = Rule.disableTriggersInternal();
            byte[] newBuffer = classfileBuffer;
            String internalName = TypeHelper.internalizeClass(className);
            if (this.isBytemanClass(internalName) || !this.isTransformable(internalName)) {
                byte[] byArray = null;
                return byArray;
            }
            ClassChecker checker = this.getClassChecker(newBuffer);
            if (checker == null || checker.isInterface()) {
                byte[] byArray = null;
                return byArray;
            }
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            LinkedList<String> toVisit = null;
            HashSet<String> visited = null;
            newBuffer = this.tryTransform(newBuffer, internalName, loader, internalName, false);
            int dotIdx = internalName.lastIndexOf(46);
            if (dotIdx > 0) {
                newBuffer = this.tryTransform(newBuffer, internalName, loader, internalName.substring(dotIdx + 1), false);
            }
            if (this.scriptRepository.checkInterfaces()) {
                toVisit = new LinkedList<String>();
                visited = new HashSet<String>();
                int interfaceCount = checker.getInterfaceCount();
                for (int i = 0; i < interfaceCount; ++i) {
                    String interfaceName = checker.getInterface(i);
                    toVisit.add(interfaceName);
                }
                while (!toVisit.isEmpty()) {
                    ClassChecker newChecker;
                    String interfaceName = (String)toVisit.pop();
                    String internalInterfaceName = TypeHelper.internalizeClass(interfaceName);
                    if (visited.contains(interfaceName)) continue;
                    visited.add(interfaceName);
                    newBuffer = this.tryTransform(newBuffer, internalName, loader, internalInterfaceName, true);
                    dotIdx = internalInterfaceName.lastIndexOf(46);
                    if (dotIdx >= 0) {
                        newBuffer = this.tryTransform(newBuffer, internalName, loader, internalInterfaceName.substring(dotIdx + 1), true);
                    }
                    if ((newChecker = this.getClassChecker(interfaceName, originalLoader)) == null) continue;
                    interfaceCount = newChecker.getInterfaceCount();
                    for (int i = 0; i < interfaceCount; ++i) {
                        interfaceName = newChecker.getInterface(i);
                        toVisit.add(interfaceName);
                    }
                }
            }
            if (!this.skipOverrideRules()) {
                String superName = checker.getSuper();
                while (superName != null && (checker = this.getClassChecker(superName, originalLoader)) != null && !checker.hasOuterClass()) {
                    newBuffer = this.tryTransform(newBuffer, internalName, loader, superName, false, true);
                    dotIdx = superName.lastIndexOf(46);
                    if (dotIdx > 0) {
                        newBuffer = this.tryTransform(newBuffer, internalName, loader, superName.substring(dotIdx + 1), false, true);
                    }
                    if (this.scriptRepository.checkInterfaces()) {
                        int interfaceCount = checker.getInterfaceCount();
                        for (int i = 0; i < interfaceCount; ++i) {
                            String interfaceName = checker.getInterface(i);
                            toVisit.add(interfaceName);
                        }
                        while (!toVisit.isEmpty()) {
                            ClassChecker newChecker;
                            String interfaceName = (String)toVisit.pop();
                            String internalInterfaceName = TypeHelper.internalizeClass(interfaceName);
                            if (visited.contains(interfaceName)) continue;
                            visited.add(interfaceName);
                            newBuffer = this.tryTransform(newBuffer, internalName, loader, internalInterfaceName, true, true);
                            dotIdx = interfaceName.lastIndexOf(46);
                            if (dotIdx >= 0) {
                                newBuffer = this.tryTransform(newBuffer, internalName, loader, internalInterfaceName.substring(dotIdx + 1), true, true);
                            }
                            if ((newChecker = this.getClassChecker(interfaceName, originalLoader)) == null) continue;
                            interfaceCount = newChecker.getInterfaceCount();
                            for (int i = 0; i < interfaceCount; ++i) {
                                interfaceName = newChecker.getInterface(i);
                                toVisit.add(interfaceName);
                            }
                        }
                    }
                    superName = checker.getSuper();
                }
            }
            if (newBuffer != classfileBuffer) {
                Transformer.maybeDumpClass(internalName, newBuffer);
                byte[] byArray = newBuffer = this.maybeVerifyTransformedBytes(originalLoader, internalName, protectionDomain, newBuffer);
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (enabled) {
                Rule.enableTriggersInternal();
            }
        }
    }

    public static boolean disableTriggers(boolean isUser) {
        Integer enabled = isEnabled.get();
        if (enabled == ENABLED) {
            isEnabled.set(isUser ? DISABLED_USER : DISABLED);
            return true;
        }
        if (enabled == DISABLED && isUser) {
            isEnabled.set(DISABLED_USER);
        }
        return false;
    }

    public static boolean enableTriggers(boolean isReset) {
        Integer enabled = isEnabled.get();
        if (enabled == ENABLED) {
            return true;
        }
        if (isReset || enabled == DISABLED) {
            isEnabled.set(ENABLED);
        }
        return false;
    }

    public static boolean isTriggeringEnabled() {
        return isEnabled.get() == ENABLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isVerbose() {
        if (Transformer.allowConfigUpdate()) {
            Object object = configLock;
            synchronized (object) {
                return verbose;
            }
        }
        return verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDumpCFG() {
        if (Transformer.allowConfigUpdate()) {
            Object object = configLock;
            synchronized (object) {
                return dumpCFG;
            }
        }
        return dumpCFG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDumpCFGPartial() {
        if (Transformer.allowConfigUpdate()) {
            Object object = configLock;
            synchronized (object) {
                return dumpCFGPartial;
            }
        }
        return dumpCFGPartial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isDumpGeneratedClasses() {
        if (Transformer.allowConfigUpdate()) {
            Object object = configLock;
            synchronized (object) {
                return dumpGeneratedClasses;
            }
        }
        return dumpGeneratedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getDumpGeneratedClassesDir() {
        if (Transformer.allowConfigUpdate()) {
            Object object = configLock;
            synchronized (object) {
                return dumpGeneratedClassesDir;
            }
        }
        return dumpGeneratedClassesDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isDumpGeneratedClassesIntermediate() {
        if (Transformer.allowConfigUpdate()) {
            Object object = configLock;
            synchronized (object) {
                return dumpGeneratedClassesIntermediate;
            }
        }
        return dumpGeneratedClassesIntermediate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDebug() {
        if (Transformer.allowConfigUpdate()) {
            Object object = configLock;
            synchronized (object) {
                return debug || verbose;
            }
        }
        return debug || verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompileToBytecode() {
        if (Transformer.allowConfigUpdate()) {
            Object object = configLock;
            synchronized (object) {
                return compileToBytecode;
            }
        }
        return compileToBytecode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean disallowDowncast() {
        if (Transformer.allowConfigUpdate()) {
            Object object = configLock;
            synchronized (object) {
                return disallowDowncast;
            }
        }
        return disallowDowncast;
    }

    public boolean skipOverrideRules() {
        return this.scriptRepository.skipOverrideRules();
    }

    public static boolean allowConfigUpdate() {
        return allowConfigUpdate;
    }

    public void updateConfiguration(String property) {
        if (Transformer.allowConfigUpdate() && property.startsWith(BYTEMAN_PACKAGE_PREFIX)) {
            this.checkConfiguration(property);
        }
    }

    protected boolean isTransformable(String className) {
        if (className.startsWith(JAVA_LANG_PACKAGE_PREFIX)) {
            return transformAll;
        }
        return true;
    }

    public static void maybeDumpClassIntermediate(String fullName, byte[] bytes) {
        if (Transformer.isDumpGeneratedClassesIntermediate()) {
            Transformer.dumpClass(fullName, bytes, true);
        }
    }

    public static void maybeDumpClass(String fullName, byte[] bytes) {
        if (Transformer.isDumpGeneratedClasses()) {
            Transformer.dumpClass(fullName, bytes);
        }
    }

    public byte[] transform(RuleScript ruleScript, ClassLoader loader, String className, byte[] targetClassBytes) {
        TransformContext transformContext = new TransformContext(this, ruleScript, className, loader, this.helperManager);
        return transformContext.transform(targetClassBytes);
    }

    protected boolean isSkipClass(Class<?> clazz) {
        if (!this.inst.isModifiableClass(clazz)) {
            return true;
        }
        if (clazz.isArray()) {
            return true;
        }
        if (clazz.isInterface()) {
            return true;
        }
        if (clazz.isPrimitive()) {
            return true;
        }
        String name = clazz.getName();
        return this.isBytemanClass(name) || !this.isTransformable(name);
    }

    private byte[] tryTransform(byte[] buffer, String name, ClassLoader loader, String key, boolean isInterface) {
        return this.tryTransform(buffer, name, loader, key, isInterface, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] tryTransform(byte[] buffer, String name, ClassLoader loader, String key, boolean isInterface, boolean isOverride) {
        List<RuleScript> ruleScripts = isInterface ? this.scriptRepository.scriptsForInterfaceName(key) : this.scriptRepository.scriptsForClassName(key);
        byte[] newBuffer = buffer;
        if (ruleScripts != null) {
            boolean counter = false;
            for (RuleScript ruleScript : ruleScripts) {
                try {
                    if (isOverride && !ruleScript.isOverride()) continue;
                    RuleScript ruleScript2 = ruleScript;
                    synchronized (ruleScript2) {
                        if (!ruleScript.isDeleted()) {
                            Transformer.maybeDumpClassIntermediate(name, newBuffer);
                            newBuffer = this.transform(ruleScript, loader, name, newBuffer);
                        }
                    }
                }
                catch (Throwable th) {
                    System.err.println("Transformer.transform : caught throwable " + th);
                    th.printStackTrace(System.err);
                }
            }
        }
        return newBuffer;
    }

    protected void dumpScript(RuleScript ruleScript) {
        String file = ruleScript.getFile();
        int line = ruleScript.getLine();
        if (file != null) {
            System.out.println("# " + file + " line " + line);
        }
        System.out.println("RULE " + ruleScript.getName());
        if (ruleScript.isInterface()) {
            System.out.println("INTERFACE " + ruleScript.getTargetClass());
        } else {
            System.out.println("CLASS " + ruleScript.getTargetClass());
        }
        System.out.println("METHOD " + ruleScript.getTargetMethod());
        if (ruleScript.getTargetHelper() != null) {
            System.out.println("HELPER " + ruleScript.getTargetHelper());
        }
        System.out.println(ruleScript.getTargetLocation());
        System.out.println(ruleScript.getRuleText());
        System.out.println("ENDRULE");
    }

    private boolean isTransformed(Class clazz, String name, boolean isInterface) {
        if (this.isBytemanClass(name) || !this.isTransformable(name)) {
            return false;
        }
        boolean found = false;
        List<RuleScript> scripts = isInterface ? this.scriptRepository.scriptsForInterfaceName(name) : this.scriptRepository.scriptsForClassName(name);
        if (scripts != null) {
            for (RuleScript script : scripts) {
                if (script.hasTransform(clazz)) continue;
                found = true;
                if (!Transformer.isVerbose()) break;
                System.out.println("Retransforming loaded bootstrap class " + clazz.getName());
                break;
            }
        }
        return found;
    }

    private ClassChecker getClassChecker(byte[] bytecode) {
        return new BytecodeChecker(bytecode);
    }

    public ClassChecker getClassChecker(String name, ClassLoader baseLoader) {
        ClassLoader loader = baseLoader;
        Class clazz = this.loadCache.lookupClass(name, loader);
        if (clazz != null) {
            return new LoadedClassChecker(clazz);
        }
        String resourceName = name.replace('.', '/') + ".class";
        try {
            InputStream is = baseLoader != null ? baseLoader.getResourceAsStream(resourceName) : ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
            if (is != null) {
                int read;
                int length = is.available();
                byte[] bytecode = new byte[length];
                for (int count = 0; count < length; count += read) {
                    read = is.read(bytecode, count, length - count);
                    if (read >= 0) continue;
                    throw new IOException("unexpected end of file");
                }
                return new BytecodeChecker(bytecode);
            }
            if (Transformer.isVerbose()) {
                System.out.println("Transformer.getClassChecker : unable to load bytecode for for class " + name);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private HashSet<String> initBlackList() {
        HashSet<String> set = new HashSet<String>();
        set.add("java.lang.Object.<init>");
        set.add("java.lang.ThreadLocal.get");
        set.add("java.lang.ThreadLocal.put");
        return set;
    }

    public boolean isBlacklisted(String triggerClassName, String targetMethodName, String targetDescriptor) {
        return this.blacklisted.contains(triggerClassName + "." + targetMethodName);
    }

    private byte[] maybeVerifyTransformedBytes(ClassLoader loader, String classname, ProtectionDomain protectionDomain, byte[] bytes) {
        if (verifyTransformedBytes) {
            return this.verifyTransformedBytes(loader, classname, protectionDomain, bytes);
        }
        return bytes;
    }

    private byte[] verifyTransformedBytes(ClassLoader loader, String classname, ProtectionDomain protectionDomain, byte[] bytes) {
        VerifyLoader verifyLoader = new VerifyLoader(loader);
        return verifyLoader.verify(classname, protectionDomain, bytes);
    }

    protected boolean isBytemanClass(String className) {
        return className.startsWith(BYTEMAN_PACKAGE_PREFIX) && !className.startsWith(BYTEMAN_TEST_PACKAGE_PREFIX) && !className.startsWith(BYTEMAN_SAMPLE_PACKAGE_PREFIX);
    }

    private static boolean computeVerbose() {
        return System.getProperty(VERBOSE) != null;
    }

    private static boolean computeDumpCFGPartial() {
        return System.getProperty(DUMP_CFG_PARTIAL) != null;
    }

    private static boolean computeDumpCFG() {
        return System.getProperty(DUMP_CFG) != null || System.getProperty(DUMP_CFG_PARTIAL) != null;
    }

    private static boolean computeDebug() {
        return System.getProperty(DEBUG) != null;
    }

    private static boolean computeCompileToBytecode() {
        return System.getProperty(COMPILE_TO_BYTECODE) != null || System.getProperty(COMPILE_TO_BYTECODE_COMPATIBILITY) != null;
    }

    private static boolean computeSkipOverrideRules() {
        return System.getProperty(SKIP_OVERRIDE_RULES) != null;
    }

    public static boolean computeDumpGeneratedClasses() {
        return System.getProperty(DUMP_GENERATED_CLASSES) != null;
    }

    public static boolean computeDumpGeneratedClassesIntermediate() {
        return System.getProperty(DUMP_GENERATED_CLASSES_INTERMEDIATE) != null;
    }

    public static String computeDumpGeneratedClassesDir() {
        String userDir = System.getProperty(DUMP_GENERATED_CLASSES_DIR);
        if (userDir != null) {
            File userFile = new File(userDir);
            if (userFile.exists() && userFile.isDirectory() && userFile.canWrite()) {
                return userDir;
            }
            return ".";
        }
        return ".";
    }

    private static boolean computeTransformAll() {
        return System.getProperty(TRANSFORM_ALL) != null || System.getProperty(TRANSFORM_ALL_COMPATIBILITY) != null;
    }

    private static boolean computeVerifyTransformedBytes() {
        return System.getProperty(VERIFY_TRANSFORMED_BYTES) != null;
    }

    private static boolean computeDisallowDowncast() {
        return System.getProperty(DISALLOW_DOWNCAST) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfiguration(String property) {
        Object object;
        boolean value;
        if (VERBOSE.equals(property)) {
            boolean value2 = Transformer.computeVerbose();
            Object object2 = configLock;
            synchronized (object2) {
                verbose = value2;
            }
            return;
        }
        if (DEBUG.equals(property)) {
            boolean value3 = Transformer.computeDebug();
            Object object3 = configLock;
            synchronized (object3) {
                debug = value3;
            }
            return;
        }
        if (COMPILE_TO_BYTECODE.equals(property)) {
            value = Transformer.computeCompileToBytecode();
            object = configLock;
            synchronized (object) {
                compileToBytecode = value;
            }
        }
        if (DUMP_GENERATED_CLASSES.equals(property)) {
            value = Transformer.computeDumpGeneratedClasses();
            object = configLock;
            synchronized (object) {
                dumpGeneratedClasses = value;
            }
        }
        if (DUMP_GENERATED_CLASSES_DIR.equals(property)) {
            String value4 = Transformer.computeDumpGeneratedClassesDir();
            object = configLock;
            synchronized (object) {
                dumpGeneratedClassesDir = value4;
            }
        }
        if (DUMP_GENERATED_CLASSES_INTERMEDIATE.equals(property)) {
            boolean value5 = Transformer.computeDumpGeneratedClassesIntermediate();
            object = configLock;
            synchronized (object) {
                dumpGeneratedClassesIntermediate = value5;
            }
        }
        if (TRANSFORM_ALL.equals(property)) {
            boolean value6 = Transformer.computeTransformAll();
            object = configLock;
            synchronized (object) {
                transformAll = value6;
            }
        }
        if (DISALLOW_DOWNCAST.equals(property)) {
            boolean value7 = Transformer.computeDisallowDowncast();
            object = configLock;
            synchronized (object) {
                disallowDowncast = value7;
            }
        }
    }

    private static void dumpClass(String fullName, byte[] bytes) {
        Transformer.dumpClass(fullName, bytes, false);
    }

    private static void dumpClass(String fullName, byte[] bytes, boolean intermediate) {
        try {
            String newname;
            int dotIdx = fullName.lastIndexOf(46);
            String name = dotIdx < 0 ? fullName : fullName.substring(dotIdx + 1);
            String prefix = dotIdx > 0 ? File.separator + fullName.substring(0, dotIdx) : "";
            String dir = Transformer.getDumpGeneratedClassesDir() + prefix.replace('.', File.separatorChar);
            if (!Transformer.ensureDumpDirectory(dir)) {
                System.out.println("org.jboss.byteman.agent.Transformer : Cannot dump transformed bytes to directory " + dir + File.separator + prefix);
                return;
            }
            if (intermediate) {
                int counter = 0;
                newname = dir + File.separator + name + "_" + counter + ".class";
                File file = new File(newname);
                while (file.exists()) {
                    newname = dir + File.separator + name + "_" + ++counter + ".class";
                    file = new File(newname);
                }
            } else {
                newname = dir + File.separator + name + ".class";
            }
            System.out.println("org.jboss.byteman.agent.Transformer : Saving transformed bytes to " + newname);
            try {
                FileOutputStream fio = new FileOutputStream(newname);
                fio.write(bytes);
                fio.close();
            }
            catch (IOException ioe) {
                System.out.println("Error saving transformed bytes to" + newname);
                ioe.printStackTrace(System.out);
            }
        }
        catch (Throwable th) {
            System.out.println("org.jboss.byteman.agent.Transformer : Error saving transformed bytes for class " + fullName);
            th.printStackTrace(System.out);
        }
    }

    private static boolean ensureDumpDirectory(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            return file.isDirectory() && file.canWrite();
        }
        return file.mkdirs();
    }

    private class VerifyLoader
    extends ClassLoader {
        public VerifyLoader(ClassLoader parent) {
            super(parent);
        }

        public byte[] verify(String classname, ProtectionDomain protectionDomain, byte[] bytes) {
            try {
                Class<?> clazz = super.defineClass(classname, bytes, 0, bytes.length, protectionDomain);
                clazz.newInstance();
            }
            catch (Throwable th) {
                System.out.println("Transformer:verifyTransformedBytes " + th);
                return null;
            }
            return bytes;
        }
    }
}

