/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.AggregatorUtils;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.SampleBuffer;
import org.openjdk.jmh.util.Statistics;

public class SampleTimeResult
extends Result<SampleTimeResult> {
    private static final long serialVersionUID = -295298353763294757L;
    private final SampleBuffer buffer;
    private final TimeUnit outputTimeUnit;

    public SampleTimeResult(ResultRole role, String label, SampleBuffer buffer, TimeUnit outputTimeUnit) {
        this(role, label, buffer, TimeValue.tuToString(outputTimeUnit) + "/op", outputTimeUnit);
    }

    SampleTimeResult(ResultRole role, String label, SampleBuffer buffer, String unit, TimeUnit outputTimeUnit) {
        super(role, label, SampleTimeResult.of(buffer, outputTimeUnit), unit, AggregationPolicy.AVG);
        this.buffer = buffer;
        this.outputTimeUnit = outputTimeUnit;
    }

    private static Statistics of(SampleBuffer buffer, TimeUnit outputTimeUnit) {
        double tuMultiplier = 1.0 * (double)outputTimeUnit.convert(1L, TimeUnit.DAYS) / (double)TimeUnit.NANOSECONDS.convert(1L, TimeUnit.DAYS);
        return buffer.getStatistics(tuMultiplier);
    }

    @Override
    public String toString() {
        Statistics stats = this.getStatistics();
        StringBuilder sb = new StringBuilder();
        sb.append("n = ").append(stats.getN()).append(", ");
        sb.append(String.format("mean = %.0f %s", stats.getMean(), this.getScoreUnit()));
        sb.append(String.format(", p{0.00, 0.50, 0.90, 0.95, 0.99, 0.999, 0.9999, 1.00} = %.0f, %.0f, %.0f, %.0f, %.0f, %.0f, %.0f, %.0f %s", stats.getPercentile(0.0), stats.getPercentile(50.0), stats.getPercentile(90.0), stats.getPercentile(95.0), stats.getPercentile(99.0), stats.getPercentile(99.9), stats.getPercentile(99.99), stats.getPercentile(100.0), this.getScoreUnit()));
        return sb.toString();
    }

    @Override
    public String extendedInfo() {
        return this.distributionExtendedInfo();
    }

    @Override
    protected Aggregator<SampleTimeResult> getThreadAggregator() {
        return new JoiningAggregator();
    }

    @Override
    protected Aggregator<SampleTimeResult> getIterationAggregator() {
        return new JoiningAggregator();
    }

    static class JoiningAggregator
    implements Aggregator<SampleTimeResult> {
        JoiningAggregator() {
        }

        @Override
        public SampleTimeResult aggregate(Collection<SampleTimeResult> results) {
            SampleBuffer buffer = new SampleBuffer();
            TimeUnit tu = null;
            for (SampleTimeResult r : results) {
                buffer.addAll(r.buffer);
                tu = r.outputTimeUnit;
            }
            return new SampleTimeResult(AggregatorUtils.aggregateRoles(results), AggregatorUtils.aggregateLabels(results), buffer, AggregatorUtils.aggregateUnits(results), tu);
        }
    }
}

