/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.util.lines;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.Optional;

public class TestLineWriter {
    private StringBuilder line = new StringBuilder();

    public TestLineWriter() {
        this.line.append("JMH ");
    }

    private void appendWithLen(String s) {
        this.appendLen(s.length());
        this.line.append(s);
        this.line.append(" ");
    }

    private void appendLen(int len) {
        this.line.append(len);
        this.line.append(" ");
    }

    private void appendTag(char tag) {
        this.line.append(tag);
        this.line.append(" ");
    }

    public void putString(String s) {
        this.appendTag('S');
        this.appendWithLen(s);
    }

    public void putOptionalInt(Optional<Integer> opt) {
        if (!opt.hasValue()) {
            this.appendTag('E');
        } else {
            this.appendTag('I');
            this.appendWithLen(String.valueOf(opt.get()));
        }
    }

    public void putOptionalString(Optional<String> opt) {
        if (!opt.hasValue()) {
            this.appendTag('E');
        } else {
            this.appendTag('S');
            this.appendWithLen(opt.get());
        }
    }

    public void putIntArray(int[] arr) {
        this.appendTag('A');
        this.appendLen(arr.length);
        for (int v : arr) {
            this.appendWithLen(String.valueOf(v));
        }
    }

    public void putOptionalStringCollection(Optional<Collection<String>> opt) {
        if (!opt.hasValue()) {
            this.appendTag('E');
        } else {
            this.appendTag('L');
            Collection<String> coll = opt.get();
            this.appendLen(coll.size());
            for (String s : coll) {
                this.appendWithLen(s);
            }
        }
    }

    public void putOptionalTimeValue(Optional<TimeValue> opt) {
        if (!opt.hasValue()) {
            this.appendTag('E');
        } else {
            this.appendTag('T');
            this.appendWithLen(opt.get().toString());
        }
    }

    public void putOptionalTimeUnit(Optional<TimeUnit> opt) {
        if (!opt.hasValue()) {
            this.appendTag('E');
        } else {
            this.appendTag('U');
            this.appendWithLen(opt.get().toString());
        }
    }

    public void putOptionalParamCollection(Optional<Map<String, String[]>> opt) {
        if (!opt.hasValue()) {
            this.appendTag('E');
        } else {
            this.appendTag('M');
            Map<String, String[]> map = opt.get();
            this.appendLen(map.size());
            for (String key : map.keySet()) {
                this.appendWithLen(key);
                String[] vals = map.get(key);
                this.appendLen(vals.length);
                for (String value : vals) {
                    this.appendWithLen(value);
                }
            }
        }
    }

    public String toString() {
        return this.line.toString();
    }
}

