/*  HelpPlugin.java  */

package nik777.aoi;

/*
 * HelpPlugin: Help system plugin for AOI
 *
 * Copyright (C) 2006 - 2007 Nik Trevallyn-Jones, Sydney, Australia
 *
 * Author: Nik Trevallyn-Jones, nik777@users.sourceforge.net
 * $Id: Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See version 2 of the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * with this program. If not, the license, including version 2, is available
 * from the GNU project, at http://www.gnu.org.
 */

/*
 *  Credits: Some code for this has been copied from the ArtOfIllusion base
 *  code written and Copyright (C) Peter Eastman.
 */

import artofillusion.*;
import artofillusion.ui.*;
import artofillusion.keystroke.*;
import artofillusion.util.SearchlistClassLoader;
import buoy.widget.*;
import buoy.event.*;
import buoyx.docking.*;
import java.util.*;
import java.util.zip.*;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.net.*;
import java.io.*;

import java.lang.reflect.*;

import javax.help.*;
import javax.swing.*;
import javax.imageio.*;

import com.jstatcom.component.*;

// the HelpGUI classes
import net.sourceforge.helpgui.gui.*;
import net.sourceforge.helpgui.page.*;
import net.sourceforge.helpgui.parser.*;

import nik777.chat.*;

/**
 */

public class HelpPlugin implements Plugin
{
    /*
    public static final int REGISTER	= -1;
    public static final int UNREGISTER	= -2;

    public static final int HELP	= -3;
    public static final int WHAT	= -4;
    public static final int HUH		= -5;

    public static final int CONTEXT	= -6;
    */

    //static HashMap pending = new HashMap(1024);
    //static HashMap registered = new HashMap(1024);

    static int helplib = 0;
    static boolean initialised=false, enabled=false;

    static HelpSet global;
    static HelpBroker broker;

    static DocSet docset;
    static String theme=null;

    protected static Properties helpprefs;

    //static HashMap loop = new HashMap(128);

    static Writer map = null;

    static BWindow aboutWin;

    protected static BFrame curr;

    StringBuffer buff = null;

    protected static final int JAVAHELP_LIB	= 1;
    protected static final int HELPGUI_LIB	= 2;

    protected static final int MB = 1024*1024;

    protected static final String mapHeader =
	"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE map PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN\" \"http://java.sun.com/products/javahelp/map_2_0.dtd\"><!-- generated by ArtOfIllusion HelpPlugin Version: 1.0, see aoisp.sourceforge.net -->\n<map version=\"1.0\">\n";

    protected File prefdir;
    protected File AppDir;

    protected boolean inChat = false;

    /**
     *  respond to events sent by AOI
     */
    public void processMessage(int message, Object args[])
    {
	LayoutWindow win;
	int i, k, c;
	if (AppDir == null)
	    AppDir = new File(ArtOfIllusion.APP_DIRECTORY);

	switch (message) {
	case Plugin.APPLICATION_STARTING:

	    // map F3 to 'huh?' mode
	    String script = load("/huh.bsh");
	    if (script != null)
		KeystrokeManager
		    .addRecord(new KeystrokeRecord(KeyEvent.VK_F3, 0,
						   "Huh Focus (HelpPlugin)",
						   script));

	    // map F2 to help mode					     
	    script = load("/help.bsh");
	    if (script != null)
		KeystrokeManager
		    .addRecord(new KeystrokeRecord(KeyEvent.VK_F2, 0,
						   "Help (HelpPlugin)",
						   script));

	    // map F1 to 'whats this?' mode
	    script = load("/what.bsh");
	    if (script != null)
		KeystrokeManager
		    .addRecord(new KeystrokeRecord(KeyEvent.VK_F1, 0,
						   "What's This? (HelpPlugin)",
						   script));

	    // initialise this HelpPlugin object
	    init();

	    break;

	case Plugin.APPLICATION_STOPPING:
	    if (map != null) {
		try {
		    map.write("\n</map>");
		    map.flush();
		} catch (Exception e) {}
		finally {
		    try {
			map.close();
		    } catch (IOException e1) {}
		}
	    }
	    break;

	case Plugin.SCENE_WINDOW_CREATED:
	    win = (LayoutWindow) args[0];

	    if (!initialised) {
		initialised = true;

		/*
		ClassLoader myldr = getClass().getClassLoader();
		if (myldr instanceof SearchlistClassLoader) {
		    URL[] srch =
			((SearchlistClassLoader) myldr).getSearchPath();

		    for (i = 0; i < srch.length; i++)
			System.out.println("search: " + srch[i]);
		}
		*/

		Locale local = Translate.getLocale();

		// HACK!! make the AOI-selected locale the default
		Locale.setDefault(local);

		HelpSet helpset;
		Page parent;
		URL helpurl;
		SearchlistClassLoader loader = new
		    SearchlistClassLoader(this.getClass().getClassLoader());
		//    (SearchlistClassLoader) this.getClass().getClassLoader();
		    
		File dir = new File(ArtOfIllusion.PLUGIN_DIRECTORY, "Help");

		/*
		 *  NTJ: hack to get library files working for the EA

		String[] jars = new String[] { "helpgui-1.1a.jar",
		    "jhall.jar", "jhelpaction.jar", "pircbot.jar",
	            "AOIHelp.zip"
		};

		URLClassLoader myldr = null;
		Method addURL = null;
		File urlfile = null;
		Object[] urlarg = new Object[1];
		try {
		    myldr = (URLClassLoader) getClass().getClassLoader();
		    Class [] sig = new Class[] { URL.class };
		    addURL = URLClassLoader.class.getDeclaredMethod("addURL",
								    sig);
		    addURL.setAccessible(true);
		} catch (Exception e) {
		    System.out.println("failed to get addURL: " + e);
		}

		for (i = 0; i < jars.length; i++) {
		    try {
			urlfile = new File(dir, jars[i]);
			urlarg[0] = urlfile.toURI().toURL();
			addURL.invoke(myldr, urlarg);
		    } catch (Exception e) {
			System.out.println("failed to update classloader: " +
					   e);
		    }
		}
		*/

		try {
		    if (loader.getResource("helpset/AOIHelp.hs") == null) {

			throw new RuntimeException("cannot load global helpset");
		    }

		    /*
		     *  NTJ: JavaHelp is optional.
		     *  If we fail to find it in the classpath, fall back to
		     *  HelpGUI
		     */
		    try {
			JHelpAction.startHelpWorker("helpset/AOIHelp.hs");

			Method getbroker =
			    JHelpAction.class.getDeclaredMethod("getHelpBroker",
							    null);
			getbroker.setAccessible(true);

			global = (HelpSet)
			    ((HelpBroker) getbroker.invoke(null, null)).getHelpSet();
			helplib = JAVAHELP_LIB;
		    } catch (Throwable e) {
			System.out.println("HelpPlugin: could not initialise JavaHelp");
		    }

		    /*
		     *  NTJ: drive HelpSet manually
		    helpurl = HelpSet.findHelpSet(loader, "helpset/AOIHelp",
						  local);

		    global = new HelpSet(helpurl);
		    broker = global.createHelpBroker();

		    final HelpBroker brok = broker;

		    (new Thread() {
			    public void run()
			    { brok.initPresentation(); }
			}).start();
		    */

		    /*
		     *  NTJ: Using (open-source) HelpGui derivative as fallback
		     */
		    java.util.List list;
		    if (helplib == 0) {
			try {
			    docset = new DocSet(Translate.getLocale());

			    list =
				PluginRegistry.getPlugins(DocSet.Parser.class);

			    DocSet.Parser parser;
			    for (i = 0; i < list.size(); i++) {
				parser = (DocSet.Parser) list.get(i);
				System.out.println("HelpPlugin.INIT: " +
						   "registering parser: " +
						   parser.getClass().getName());
				DocSet.registerParser(parser);
			    }

			    docset.setLoader(loader);
			    docset.add("helpset/AOIHelp.hs", null);
			    
			    helplib = HELPGUI_LIB;
			} catch (Throwable t) {
			    System.out.println("HelpPlugin: could not initialise HelpGUI");
			}
		    }

		    helpset = global;
		    parent = null;

		    enabled = (helplib != 0);

		    /*
		     *  scan Plugins/Help and add any help resources found.
		     */

		    File files[] = dir.listFiles();
		    File subdir[], helpfile;
		    int cut, subcount;

		    ZipFile zf = null;
		    ZipEntry ze = null;
		    String basename;
		    ClassLoader ldr;
		    URL url[] = new URL[1];

		    for (i = 0; i < files.length; i++) {

			// create a subsection for each subdirectory
			if (files[i].isDirectory()) {
			    subdir = files[i].listFiles();
			    subcount = subdir.length;

			    if (subcount > 0) {
				if (helplib == JAVAHELP_LIB) {
				    helpset = new HelpSet(loader);
				    global.add(helpset);
				}
				else if (helplib == HELPGUI_LIB) {
				    parent = docset.addSection(files[i].getName(), null);
				}
			    }
			}
			else {
			    subdir = null;
			    subcount = 1;
			    helpset = global;
			    parent = null;
			}

			for (k = 0; k < subcount; k++) {
			    helpfile = (subdir != null ? subdir[k] : files[i]);

			    try {
				// look inside all zip files
				zf = new ZipFile(helpfile);

				// look for a helpset entry (*.hs)
				Enumeration iter = zf.entries();
				while (iter.hasMoreElements()) {
				    ze = (ZipEntry) iter.nextElement();
				    if (ze.isDirectory()) continue;
				    if (ze.getName().endsWith(".hs")) break;
				    ze = null;
				}

				// no helpset entry found, try next...
				if (ze == null) continue;

				basename = ze.getName();
				cut = basename.lastIndexOf('.');
				if (cut > 0)
				    basename = basename.substring(0, cut);

				// if it's a helpset, add it to the resources
				System.out.println("HelpPlugin.ADD: " +
						   basename);


				url[0] = helpfile.toURI().toURL();
				ldr = new URLClassLoader(url);
				PluginRegistry.registerResource("help",
								basename,
								ldr,
								ze.getName(),
								null);

			    } catch (Exception e) {}
			    finally {
				if (zf != null) {
				    zf.close();
				    zf = null;
				}
			    }
			}
		    }

		    HelpSet plugset=null;
		    if (helplib == JAVAHELP_LIB) plugset = new HelpSet(loader);

		    // load all the registered help resources
		    list = PluginRegistry.getResources("help");

		    System.out.println("resources found=" + list.size());

		    if (list.size() > 0) {
			if (docset != null)
			    parent = docset.addSection("Plugins", null);

			PluginRegistry.PluginResource resource;
			for (i = 0; i < list.size(); i++) {
			    resource =
				(PluginRegistry.PluginResource) list.get(i);

			    // don't load global help a second time
			    if (resource.getId().equals("helpset/AOIHelp"))
				continue;

			    System.out.println("Help: linking: " +
					       resource.getURL().getPath());

			    loader.add(resource.getClassLoader());

			    System.out.println("loading: " + resource.getId() +
					       " from " +
					       resource.getURL().getPath());

			    /*
			     * NTJ: *ugh* After all that work, something in
			     *   in JavaHelp is only using the loader of the
			     *   plugin. I suspect it is JHelpDev...
			     */

			    if (plugset != null)
				//plugset.add(new HelpSet(resource.getClassLoader(), resource.getURL()));
				plugset.add(new HelpSet(loader, resource.getURL()));
			    else {
				loader.add(resource.getClassLoader());
				docset.add(resource.getURL().getPath(),parent);
			    }
			}
		    }

		    if (helpset != null) helpset.add(plugset);

		} catch (Exception e) {
		    System.out.println("HelpPlugin.INIT: " + e);
		    e.printStackTrace(System.out);
		}
	    }

	    // now register the new LayoutWindow
	    try {
		BMenuItem item;

		BMenuBar mbar = win.getMenuBar();
		BMenu helpmenu = Translate.menu("HelpPlugin:Help");
		mbar.add(helpmenu);

		helpmenu.add(item=Translate.menuItem("HelpPlugin:AOIHelp",
						     this, "show"));
		item.setEnabled(enabled);

		helpmenu.add(item=Translate.menuItem("HelpPlugin:WhatsThis",
						     this, "what"));

		item.setEnabled(enabled && (helplib == JAVAHELP_LIB));

		helpmenu.add(item=Translate.menuItem("HelpPlugin:LiveHelp",
						     this, "chat"));

		helpmenu.addSeparator();

		helpmenu.add(item=Translate.menuItem("HelpPlugin:About",
						     this, "about"));

	    } catch (Exception e) {
		System.out.println("HelpPlugin: error adding menu: " + e);
	    } catch (Throwable t) {
		System.out.println("HelpPlugin: error adding menu: " + t);
		t.printStackTrace(System.out);
		return;
	    }

	    // register all unregistered DockableWidgets
	    DockingContainer dock;
	    DockableWidget dockable;
	    Component comp;
	    Object obj;

	    for (i = 0; i < 4; i++) {
		switch (i) {
		case 0: 
		    dock = win.getDockingContainer(BTabbedPane.TOP);
		    break;

		case 1: 
		    dock = win.getDockingContainer(BTabbedPane.BOTTOM);
		    break;

		case 2: 
		    dock = win.getDockingContainer(BTabbedPane.LEFT);
		    break;

		case 3: 
		    dock = win.getDockingContainer(BTabbedPane.RIGHT);
		    break;

		default:
		    return;
		}

		Iterator iter = dock.getChildren().iterator();
		while (iter.hasNext()) {
		    obj = iter.next();
		    if (obj instanceof DockableWidget)
			dockable = (DockableWidget) obj;
		    else continue;
		    
		    comp = dockable.getComponent();

		    //System.out.println("dockable ID=" +
		    //	       CSH.getHelpIDString(comp));

		    // only if JavaHelp is being used
		    if (helplib == JAVAHELP_LIB &&
			CSH.getHelpIDString(comp) == null) {

			register(comp, "Docking." + dockable.getLabel(), null);
		    }
		}
	    }

	    // register the window
	    register(args[0], "LayoutWindow", null);

	    break;

	case Plugin.SCENE_WINDOW_CLOSING:
	    // unregister window
	    register(args[0], null, null);
	    break;

	    /*
	case REGISTER:
	    //pending.put(args[0], (String) args[1]);
	    register(args[0], (String) args[1], null);
	    break;

	case UNREGISTER:
	    register(args[0], null, null);
	    */
	    /*
	    {
		String id = (String) args[1];
		String regid = (String) pending.get(args[0]);
		if (id.equals(regid)) {
		    pending.remove(args[0]);
		}
		else {
		    regid = (String) registered.get(args[0]);
		    if (id.equals(regid)) {
			register(args[0], null, null);

			registered.remove(args[0]);
		    }
		}
	    }
	    */

	    /*
	    break;

	case HELP:
	    show(null);
	    break;

	case HUH:
	    huh(null);
	    break;

	case WHAT:
	    what(null);
	    break;

	case CONTEXT:
	    System.out.println("Help.CONTEXT: " + curr);
	    args[0] = curr;
	    break;
	    */
	}
    }

    public void init()
    {
	if (prefdir == null)
	    prefdir = ApplicationPreferences.getPreferencesDirectory();

	File helpflags = new File(prefdir, "HelpPlugin.props");

	if (helpflags.exists()) {
	    System.out.println("HelpPlugin.init: processing prefs");
	    InputStream in = null;
		
	    try {
		helpprefs = new Properties();
		in = new FileInputStream(helpflags);
		helpprefs.load(in);

		String mapfile = helpprefs.getProperty("MapFile");
		if (mapfile != null && mapfile.length() > 0) {
		    System.out.println("HelpPlugin.init: mapfile=" +
				       mapfile);

		    map = new OutputStreamWriter(new FileOutputStream(mapfile), "UTF-8");
		    map.write(mapHeader);
		}
		
		theme = helpprefs.getProperty("Theme");
		
	    } catch (IOException e) {
		System.out.println("HelpPlugin: reading HelpFlags: " + e);
	    }
	    finally {
		if (in != null) try { in.close(); } catch (IOException e){}
	    }
	}

	if (theme == null) theme = "plastic";

	try {
	    PluginRegistry.registerResource("TranslateBundle", "HelpPlugin",
					    getClass().getClassLoader(),
					    "helpplugin", null);

	} catch (Exception e) {}

	// register the best-match for the current locale
	try {
	    Locale local = Translate.getLocale();
	    ClassLoader loader = getClass().getClassLoader();

	    PluginRegistry.invokeExportedMethod("artofillusion.SPManager.registerResource", new Object[] { "TranslateBundle", "HelpPlugin", loader, "helpplugin", local});

	} catch (Exception e) {}
    }

    public BFrame getContext()
    { return curr; }

    public void show(WidgetEvent ev)
    {
	if (ev != null) curr = UIUtilities.findFrame(ev.getWidget());
	System.out.println("Help.show: curr=" + curr);

	if (helplib == JAVAHELP_LIB) JHelpAction.showHelp();
	else if (helplib == HELPGUI_LIB) {
	    HelpFrame helpframe = new HelpFrame(docset, theme);

	    try {
		URL url = getClass().getResource("/artofillusion/Icons/appIcon.png");
		if (url != null) helpframe.setIconImage(ImageIO.read(url.openStream()));
		else System.out.println("HelpPlugin.show: cannot find icon");
	    } catch (Exception e) {
		System.out.println("HelpPlugin.show: " + e);
	    }
	    //UIUtilities.centerWindow(helpframe);
	    helpframe.setVisible(true);
	}
    }

    public void huh(WidgetEvent ev)
    {
	if (ev != null) curr = UIUtilities.findFrame(ev.getWidget());
	if (helplib == JAVAHELP_LIB) JHelpAction.showHelpFromFocus();
    }

    public void what(WidgetEvent ev)
    {
	//long now = System.currentTimeMillis();

	/*
	// perform any outstanding registrations
	if (pending.size() > 0) {
	    java.util.Map.Entry entry;
	    Iterator iter = pending.entrySet().iterator();
	    while (iter.hasNext()) {
		entry = (java.util.Map.Entry) iter.next();
		loop.clear();
		register(entry.getKey(), (String) entry.getValue(), null);
	    }
	    
	    System.out.println("HelpPlugin.what: " + pending.size() +
			       " registrations done in " +
			       ((System.currentTimeMillis() - now)/1000) +
			       " secs");

	    registered.putAll(pending);
	    pending.clear();
	}
	*/

	if (ev != null) curr = UIUtilities.findFrame(ev.getWidget());
	if (helplib == JAVAHELP_LIB) JHelpAction.trackFieldHelp();
    }

    public void chat(WidgetEvent ev)
    {
	File path = new File(AppDir, "Plugins");
	path = new File(path, "HelpPlugin.jar");

	try {
	    String[] cmd = new String[] {
		"java", "-jar", path.getAbsolutePath(), "-c", "chat"
	    };

	    Runtime.getRuntime().exec(cmd);
	} catch (Throwable t) {
	    System.out.println("Error invoking help: " + t);
	}
    }

    public void chat()
    {
	//WindowWidget parent = UIUtilities.findWindow(ev.getWidget());
	Color frameColour=null;
	Font font=null;
	String tmp, id=null, chan="#aoi";

	System.out.println("helpprefs=" + helpprefs);

	if (helpprefs != null) {
	    try {
		tmp = helpprefs.getProperty("chat.colour");
		if (tmp != null) frameColour = Color.decode(tmp);
	    } catch (Exception e) {}

	    try {
		tmp = helpprefs.getProperty("chat.font");
		if (tmp != null) font = Font.decode(tmp);
	    } catch (Exception e) {}

	    chan = helpprefs.getProperty("chat.channel");
	    id = helpprefs.getProperty("chat.id");
	}
	if (frameColour == null) frameColour = new Color(204, 204, 255);
	if (font == null) font = Font.decode("Arial-PLAIN-12");
	if (chan == null) chan = "#aoi";

	// get (id) and password
	BTextField chanField = new BTextField(chan, 15);
	BTextField idField = new BTextField(id, 15);
	BPasswordField pwField = new BPasswordField("", 15);
	pwField.setEchoChar('*');

	idField.requestFocus();

	Widget[] widgets = new Widget[] { chanField, idField, pwField };
	String[] labels = new String[] {
	    Translate.text("HelpPlugin:channel"),
	    Translate.text("HelpPlugin:name"),
	    Translate.text("HelpPlugin:password")
	};

	inChat = false;
	
	ComponentsWindow dlg = new
	    ComponentsWindow(Translate.text("HelpPlugin:login"), widgets,
			     labels);

	System.out.println("window closed...");

	if (!dlg.clickedOk()) return;

	inChat = true;
	System.out.println("ok, connecting to IRC...");

	chan = chanField.getText();
	id = idField.getText();
	
	ChatFrame chat = new ChatFrame(frameColour, font, id, chan, true);
	if (theme != null) chat.iconsPath = theme;

	IRCConnector irc = new IRCConnector();
	chat.open(irc);
	chat.join(chan, id, pwField.getText());
	chat.semaphore(this);

	//UIUtilities.centerDialog(chat);
	chat.setVisible(true);

	// update the prefs
	if (prefdir != null) {
	    if (helpprefs == null) helpprefs = new Properties();

	    helpprefs.setProperty("chat.channel", chan);
	    helpprefs.setProperty("chat.id", id);
	    helpprefs.setProperty("chat.font", font.getFontName() +
				  " " + font.getSize());

	    try {
		File helpprops = new File(prefdir, "HelpPlugin.props");

		OutputStream os = new FileOutputStream(helpprops);
		helpprefs.store(os, "# (re)generated by HelpPlugin");

		os.flush();
		os.close();

	    } catch (Exception e) {
		System.out.println("HelpPlugin.chat: savinf prefs: " + e);
	    }
	}
    }

    /**
     *  display an About window.
     *
     *  Base code flagrantly copied from the AOI TitleWindow, written and
     *  Copyright (C) Peter Eastman.
     */
    public void about()
    {
	try {
	    aboutWin = new BWindow();
	    aboutWin.addEventLink(MouseClickedEvent.class, new Object(){
			void processEvent()
			{
			    aboutWin.setVisible(false);
			    aboutWin.dispose();
			}
		    });

	    // collect useful information
	    Runtime runtime = Runtime.getRuntime();
	    int cpus = 1;
	    try {
		cpus = runtime.availableProcessors();
	    } catch (Exception e) {}

	    String vname = ArtOfIllusion.getVersion();

	    int imageNumber = new Random(System.currentTimeMillis()).nextInt(8);
	    ImageIcon image = new ImageIcon(getClass().getResource("/artofillusion/titleImages/titleImage"+imageNumber+".jpg"));

	    String text = "<html><div align='center'>" +
		"Art Of Illusion v" + vname +
		"<br>Copyright 1999-2013 by Peter Eastman and others"+
		"<br>(See the README file for details.)"+
		"<br>This program may be freely distributed under"+
		"<br>the terms of the accompanying license.</div>" +
		"<p><div align='left'><hr>" +
		Translate.text("HelpPlugin:java",
			       System.getProperty("java.version"),
			       System.getProperty("java.vendor")) +
	        "<br>" + Translate.text("HelpPlugin:OS", new Object[] {
			System.getProperty("os.name"),
			System.getProperty("os.version"),
			System.getProperty("os.arch")
		    }) +
		"<br>" + Translate.text("HelpPlugin:memory", new Object[] {
			new Long((runtime.totalMemory()
				     - runtime.freeMemory()) / MB),
			new Long(runtime.totalMemory() / MB),
			new Long(runtime.maxMemory() / MB),
		    }) +
		"<br>" + Translate.text("HelpPlugin:cpus", new Integer(cpus)) +
		"<br>" + Translate.text("HelpPlugin:opengl",
					(ViewerCanvas.isOpenGLAvailable()
					 ? Translate.text("HelpPlugin:available")
					 : Translate.text("HelpPlugin:unavailable")),
					(ArtOfIllusion.getPreferences().getUseOpenGL()
					 ? Translate.text("HelpPlugin:enabled")
					 : Translate.text("HelpPlugin:disabled"))) +
		"</div></html>";

	    BLabel label = new BLabel(text, image, BLabel.NORTH, BLabel.SOUTH);
	    label.setFont(new Font("Serif", Font.PLAIN, 12));
	    BOutline content = BOutline.createLineBorder(new BOutline(label, BorderFactory.createEmptyBorder(0, 0, 5, 0)), Color.BLACK, 1);
	    Color background = Color.white;
	    if (imageNumber == 4)
		background = new Color(204, 204, 255);
	    else if (imageNumber == 6)
		background = new Color(232, 255, 232);
	    UIUtilities.applyBackground(content, background);
	    aboutWin.setContent(content);
	    aboutWin.pack();
	    Rectangle bounds = aboutWin.getBounds();
	    bounds.height++;
	    aboutWin.setBounds(bounds); // Workaround for Windows bug
	    UIUtilities.centerWindow(aboutWin);
	    aboutWin.setVisible(true);

	} catch (Exception e) {
	    System.out.println("HelpPlugin.about: " + e);
	}
    }

    public static void register(Object obj, String id)
    { register(obj, id, null); }

    public static void unregister(Object obj)
    { register(obj, null, null); }

    /**
     *  register the specified object with the Help system
     */
    public static void register(Object obj, String id, HelpSet helpset)
    {
	System.out.println(id != null ? "registering " + id : "unregistering");

	if (helplib != JAVAHELP_LIB) return;

	Component component = null;

	// register the object if it is a component itself

	if (obj instanceof Component)
	    component = (Component) obj;
	else if (obj instanceof Widget)
	    component = ((Widget) obj).getComponent();

	if (component != null) {

	    System.out.println("component= " +
			       component.getClass().getName());

	    CSH.setHelpIDString(component, id);

	    if (id != null) {
		if (global == null) System.out.println("global is null");

		if (helpset != null) CSH.setHelpSet(component, helpset);
		else if (global != null) CSH.setHelpSet(component, global);

		System.out.println("Mapped ID=" +
				   CSH.getHelpIDString(component));

		if (map != null) {
		    try {
			map.write("\n<mapID target=\"");
			map.write(id);
			map.write("\" url=\"\" />");
		    } catch (IOException e) {
			System.out.println("HelpPlugin.register writing map: "+
					   e);
		    }
		}
	    }
	}

	/*
	 *  NTJ - no need to recurse, let Help system do it at runtime
	 *
	// now register any fields that are components
	Field field[] = obj.getClass().getDeclaredFields();
	Field fld;
	Class type;
	Object child;

	for (int i = 0; i < field.length; i++) {
	    fld = field[i];

	    if (Modifier.isStatic(fld.getModifiers())
		|| fld.getName().indexOf('$') >= 0)
		continue;

	    try {
		type = fld.getType();

		if (Widget.class.isAssignableFrom(type)
		    || Component.class.isAssignableFrom(type)) {

		    fld.setAccessible(true);
		    child = fld.get(obj);

		    if (child != null && child != obj
			&& !loop.containsKey(child)) {
			
			System.out.println("Help.register: child=" +
					   fld.getName());

			loop.put(child, obj);

			register(child, id + "." + fld.getName(), helpset);
		    }
		}
	    } catch (Exception e) {
		System.out.println("HelpPlugin.register (" + id + "): " + e);
	    }
	}
	*/
    }

    /**
     *  create a map of IDs
     */
    public static void makeMap_dont_use(String id, Object obj, Writer map)
    {
	Field field[] = null;
	Field fld;
	Object child;
	Widget widget = null;
	Component component = null;

	int i;

	// find the top-level container
	if (obj instanceof Widget) {
	    widget = (Widget) obj;
	    Widget parent = widget.getParent();

	    try {
		while (parent != null) {
		    System.out.println("Help.makeMap: parent=" +
				       parent.getClass().getName());

		    System.out.println("pop");
		    widget = parent;
		    parent = widget.getParent();

		    /*
		    field = parent.getClass().getDeclaredFields();

		    for (i = 0; i < field.length; i++) {
			fld = field[i];

			fld.setAccessible(true);
			if (fld.get(parent) == widget) {
			    System.out.println("Help.makeMap: popping...");
			    widget = parent;
			    parent = widget.getParent();
			    break;
			}
		    }
		    
		    // we fell through so this is our top-most level
		    if (i >= field.length) break;
		    */
		}

	    } catch (Exception e) {
		System.out.println("HelpPlugin.makeMap: finding top: " +e);
	    }

	    obj = widget;
	}

	else if (obj instanceof Component) {
	    component = (Component) obj;
	    Component parent = component.getParent();

	    try {
		while (parent != null) {
		    field = parent.getClass().getDeclaredFields();

		    System.out.println("Help.makeMap: parent=" +
				       parent.getClass().getName());

		    System.out.println("pop");
		    component = parent;
		    parent = component.getParent();

		    for (i = 0; i < field.length; i++) {
			fld = field[i];

			fld.setAccessible(true);
			if (fld.get(parent) == component) {
			    System.out.println("Help.makeMap: found top");
			    parent = null;
			    break;
			}
		    }

		    // we fell through so pop a level
		    if (i >= field.length) {
			System.out.println("pop...");
			component = parent;
			parent = component.getParent();
		    }
		}
	    } catch (Exception e) {
		System.out.println("HelpPlugin.makeMap: finding top: " +e);
	    }

	    obj = component;
	}

	System.out.println("HelpPlugin.makeMap: top level is a " +
			   obj.getClass().getName());

	try {
	    // map the object if it is a component itself
	    if (widget != null || component != null) {
		map.write("\n<mapID target='");
		map.write(id);
		map.write("' url='' />");
	    }

	    // now map any fields that are components
	    field = obj.getClass().getDeclaredFields();
	    Class type;
	    String name;

	    for (i = 0; i < field.length; i++) {
		fld = field[i];

		name = fld.getName();
		System.out.println("Help.makeMap: field=" + name);

		if (Modifier.isStatic(fld.getModifiers())
		    || name.length() == 0 || name.indexOf('$') >= 0)
		    continue;

		try {
		    type = fld.getType();

		    if (Widget.class.isAssignableFrom(type)
			|| Component.class.isAssignableFrom(type)) {

			fld.setAccessible(true);
			
			child = fld.get(obj);

			if (child != null && child != obj)
			    makeMap_dont_use(id + "." + name, child, map);
		    }
		} catch (Exception e) {
		    System.out.println("HelpPlugin.makeMap (" + id + "): " +e);
		}
	    }

	} catch (IOException e) {
	    System.out.println("HelpPlugin.makeMap: " + e);
	}
    }

    protected String load(String path)
    {
	if (buff == null) buff = new StringBuffer(512);
	else buff.setLength(0);

	InputStream is = null;

	try {
	    is = getClass().getResourceAsStream(path);
	    if (is == null) return null;

	    InputStreamReader in = new InputStreamReader(is, "UTF-8");

	    int c;
	    while ((c = in.read()) != -1) buff.append((char) c);

	} catch (IOException e) {
	    System.out.println("HelpPlugin: unable to load resource: " + e);
	} finally {
	    try { is.close(); } catch (Exception e1) {}
	}

	return (buff.length() > 0 ? buff.toString() : null);
    }

    /**
     *  main, so Help can be run standalone.
     */
    public static void main(String[] argv)
    {
	char slash = File.separatorChar;

	String AppDir = System.getProperty("user.dir");
	try {
	    URL url = HelpPlugin.class
		.getResource("/nik777/aoi/HelpPlugin.class");

	    System.out.println("HelpPlugin.main: url=" + url);

	    System.out.println("HelpPlugin.main: path=" + url.getPath());

	    String furl = url.getPath();
	    if (furl.indexOf('!') < 0) furl = url.toString();

	    int cut = furl.indexOf('!');

	    if (cut > 0) {

		furl = furl.substring(0, cut);

		cut = furl.indexOf("jar:");
		if (cut >= 0)
		    furl = furl.substring(cut+"jar:".length());

		if (!furl.startsWith("file:")) furl = "file:" + furl;

		System.out.println("HelpPlugin.main: furl=" + furl);

		File dir = new File(new URL(furl).getPath()).getParentFile()
		    .getParentFile();

		System.out.println("HelpPlugin.main: dir=" +
				   dir.getAbsolutePath());

		if (dir.exists())
		    AppDir = dir.getAbsolutePath();
		else
		    AppDir = System.getProperty("user.dir");

		System.out.println("HelpPlugin.main: app_dir=" + AppDir);
	    }
	}
	catch (Exception ex) {
	    System.out.println("Error looking up app_dir: " + ex);
	}

	HelpPlugin help = new HelpPlugin();
	help.AppDir = new File(AppDir);
	help.init();

	String cmd = null;
	for (int i = 0; i < argv.length; i++) {
	    if (argv[i].equalsIgnoreCase("-c")) {
		if (i < argv.length-1) cmd = argv[i+1];

		break;
	    }
	}

	if (cmd.equalsIgnoreCase("chat")) help.chat();
	else if (cmd.equalsIgnoreCase("show"));

	if (help.inChat) {
	    synchronized (help) {
		try {
		    help.wait();
		} catch (Exception e) {}
	    }
	}

	System.exit(0);
    }
}
