package org.gudy.azureus2.ui.console.commands;

import java.io.PrintStream;
import java.util.*;

import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.download.DownloadStub.DownloadStubFile;
import org.gudy.azureus2.ui.console.ConsoleInput;



public class Archive extends IConsoleCommand {

	public Archive()
	{
		super("archive", "ar");
	}
	
	public String getCommandDescriptions()
	{
		return("archive\t\tar\tLists, and allows the restoration of, archived downloads.");
	}
	
	public void printHelpExtra(PrintStream out, List args) {
		out.println("> -----");
		out.println("Subcommands:");
		out.println("list\t\tl\t\tList archived downloads");
		out.println("show <num>\ts\t\tShow archived download");
		out.println("restore <num>\tres\t\tRestore archived download");
		out.println("delete <num>\tdel\t\tDelete archived download");
		out.println("> -----");
	}
	
	public void 
	execute(
		String commandName, ConsoleInput ci, List<String> args) {
				
		if ( args.size() > 0 ){
			
			PluginInterface pi = ci.getCore().getPluginManager().getDefaultPluginInterface();
			
			DownloadStub[] stubs = pi.getDownloadManager().getDownloadStubs();

			String sub = args.get(0);
			
			int	index = -1;
			
			if ( args.size() > 1 ){
				
				String index_str = args.get(1);
				
				try{
					index = Integer.parseInt( index_str );
					
					index--;
					
					if ( index < 0 || index >= stubs.length ){
											
						index = -1;
					}
					
				}catch( Throwable e ){
				}
				
				if ( index == -1 ){
					
					ci.out.println( "Invalid archive index: " + index_str );
				}
			}
			
			if ( sub.equals( "list" ) || sub.equals( "l" )){
					
				int pos = 1;
				
				ci.out.println( "> -----" );
				
				for ( DownloadStub stub: stubs ){
					
					System.out.println( " " + (pos++) + "\t" + stub.getName() + " (" + DisplayFormatters.formatByteCountToKiBEtc( stub.getTorrentSize()) + ")");
				}
				
				ci.out.println( "> -----" );
				
			}else if ( index != -1 && ( sub.equals( "show" ) || sub.equals( "s" ))){
				
				try{
					DownloadStub stub = stubs[index];
					
					ci.out.println( "> -----" );
					ci.out.println( "  " + stub.getName() + " - hash=" + ByteFormatter.encodeString( stub.getTorrentHash()));
					
					DownloadStubFile[] files = stub.getStubFiles();
					
					ci.out.println( "  Files: " + files.length );
					
					for ( DownloadStubFile file: files ){
						
						long	length = file.getLength();
						
						ci.out.println( "    " + file.getFile() + " - " + (length < 0?("Not downloaded"):DisplayFormatters.formatByteCountToKiBEtc( length )));
					}
					
					ci.out.println( "> -----" );
					
				}catch( Throwable e ){
					
					ci.out.print( e );
				}

			}else if ( index != -1 && ( sub.equals( "restore" ) || sub.equals( "res" ))){
								
				try{
					Download d = stubs[index].destubbify();
					
					ci.out.println( "> Restore of " + d.getName() + " succeeded." );
					
				}catch( Throwable e ){
					
					ci.out.print( e );
				}
				
			}else if ( index != -1 && ( sub.equals( "delete" ) || sub.equals( "del" ))){	
					
				try{
					DownloadStub stub = stubs[index];
					
					String 	name = stub.getName();
					
					stub.remove();
					
					ci.out.println( "> Delete of " + name + " succeeded." );

				}catch( Throwable e ){
					
					ci.out.print( e );
				}

			}else{
			
				ci.out.println( "Unsupported sub-command: " + sub );
				
				return;
			}
		}else{
			
			printHelp( ci.out, args );
		}
		
	}
}
