package org.jabref.logic.formatter.casechanger;

import org.jabref.logic.l10n.Localization;
import org.jabref.model.cleanup.Formatter;

public class UpperCaseFormatter implements Formatter {

    @Override
    public String getName() {
        return Localization.lang("Upper case");
    }

    @Override
    public String getKey() {
        return "upper_case";
    }

    /**
     * Converts all characters of the given string to upper case, but does not change words starting with "{"
     */
    @Override
    public String format(String input) {
        Title title = new Title(input);

        title.getWords().stream().forEach(Word::toUpperCase);

        return title.toString();
    }

    @Override
    public String getDescription() {
        return Localization.lang(
                "Changes all letters to upper case.");
    }

    @Override
    public String getExampleInput() {
        return "Kde {Amarok}";
    }

}
