package org.jabref.model.strings;

import java.util.HashMap;

public class UnicodeToReadableCharMap extends HashMap<String, String> {
    public UnicodeToReadableCharMap() {
        put("\u00C0", "A");
        put("\u00C1", "A");
        put("\u00C2", "A");
        put("\u00C3", "A");
        put("\u00C4", "Ae");
        put("\u00C5", "Aa");
        put("\u00C6", "Ae");
        put("\u00C7", "C");
        put("\u00C8", "E");
        put("\u00C9", "E");
        put("\u00CA", "E");
        put("\u00CB", "E");
        put("\u00CC", "I");
        put("\u00CD", "I");
        put("\u00CE", "I");
        put("\u00CF", "I");
        put("\u00D0", "D");
        put("\u00D1", "N");
        put("\u00D2", "O");
        put("\u00D3", "O");
        put("\u00D4", "O");
        put("\u00D5", "O");
        put("\u00D6", "Oe");
        put("\u00D8", "Oe");
        put("\u00D9", "U");
        put("\u00DA", "U");
        put("\u00DB", "U");
        put("\u00DC", "Ue"); // U umlaut ..
        put("\u00DD", "Y");
        put("\u00DF", "ss");
        put("\u00E0", "a");
        put("\u00E1", "a");
        put("\u00E2", "a");
        put("\u00E3", "a");
        put("\u00E4", "ae");
        put("\u00E5", "aa");
        put("\u00E6", "ae");
        put("\u00E7", "c");
        put("\u00E8", "e");
        put("\u00E9", "e");
        put("\u00EA", "e");
        put("\u00EB", "e");
        put("\u00EC", "i");
        put("\u00ED", "i");
        put("\u00EE", "i");
        put("\u00EF", "i");
        put("\u00F0", "o");
        put("\u00F1", "n");
        put("\u00F2", "o");
        put("\u00F3", "o");
        put("\u00F4", "o");
        put("\u00F5", "o");
        put("\u00F6", "oe");
        put("\u00F8", "oe");
        put("\u00F9", "u");
        put("\u00FA", "u");
        put("\u00FB", "u");
        put("\u00FC", "ue"); // u umlaut...
        put("\u00FD", "y");
        put("\u00FF", "y");
        put("\u0100", "A");
        put("\u0101", "a");
        put("\u0102", "A");
        put("\u0103", "a");
        put("\u0104", "A");
        put("\u0105", "a");
        put("\u0106", "C");
        put("\u0107", "c");
        put("\u0108", "C");
        put("\u0109", "c");
        put("\u010A", "C");
        put("\u010B", "c");
        put("\u010C", "C");
        put("\u010D", "c");
        put("\u010E", "D");
        put("\u010F", "d");
        put("\u0110", "D");
        put("\u0111", "d");
        put("\u0112", "E");
        put("\u0113", "e");
        put("\u0114", "E");
        put("\u0115", "e");
        put("\u0116", "E");
        put("\u0117", "e");
        put("\u0118", "E");
        put("\u0119", "e");
        put("\u011A", "E");
        put("\u011B", "e");
        put("\u011C", "G");
        put("\u011D", "g");
        put("\u011E", "G");
        put("\u011F", "g");
        put("\u0120", "G");
        put("\u0121", "g");
        put("\u0122", "G");
        put("\u0123", "g");
        put("\u0124", "H");
        put("\u0125", "h");
        put("\u0127", "h");
        put("\u0128", "I");
        put("\u0129", "i");
        put("\u012A", "I");
        put("\u012B", "i");
        put("\u012C", "I");
        put("\u012D", "i");
        put("\u012E", "I");
        put("\u012F", "i");
        put("\u0130", "I");
        put("\u0131", "i");
        put("\u0132", "IJ");
        put("\u0133", "ij");
        put("\u0134", "J");
        put("\u0135", "j");
        put("\u0136", "K");
        put("\u0137", "k");
        put("\u0138", "k");
        put("\u0139", "L");
        put("\u013A", "l");
        put("\u013B", "L");
        put("\u013C", "l");
        put("\u013D", "L");
        put("\u013E", "l");
        put("\u013F", "L");
        put("\u0140", "l");
        put("\u0141", "L");
        put("\u0142", "l");
        put("\u0143", "N");
        put("\u0144", "n");
        put("\u0145", "N");
        put("\u0146", "n");
        put("\u0147", "N");
        put("\u0148", "n");
        put("\u0149", "n");
        put("\u014A", "N");
        put("\u014B", "n");
        put("\u014C", "O");
        put("\u014D", "o");
        put("\u014E", "O");
        put("\u014F", "o");
        put("\u0150", "Oe");
        put("\u0151", "oe");
        put("\u0152", "OE");
        put("\u0153", "oe");
        put("\u0154", "R");
        put("\u0155", "r");
        put("\u0156", "R");
        put("\u0157", "r");
        put("\u0158", "R");
        put("\u0159", "r");
        put("\u015A", "S");
        put("\u015B", "s");
        put("\u015C", "S");
        put("\u015D", "s");
        put("\u015E", "S");
        put("\u015F", "s");
        put("\u0160", "S");
        put("\u0161", "s");
        put("\u0162", "T");
        put("\u0163", "t");
        put("\u0164", "T");
        put("\u0165", "t");
        put("\u0166", "T");
        put("\u0167", "t");
        put("\u0168", "U");
        put("\u0169", "u");
        put("\u016A", "U");
        put("\u016B", "u");
        put("\u016C", "U");
        put("\u016D", "u");
        put("\u016E", "UU");
        put("\u016F", "uu");
        put("\u0170", "Ue");
        put("\u0171", "ue");
        put("\u0172", "U");
        put("\u0173", "u");
        put("\u0174", "W");
        put("\u0175", "w");
        put("\u0176", "Y");
        put("\u0177", "y");
        put("\u0178", "Y");
        put("\u0179", "Z");
        put("\u017A", "z");
        put("\u017B", "Z");
        put("\u017C", "z");
        put("\u017D", "Z");
        put("\u017E", "z");
        put("\u1EBC", "E");
        put("\u1EBD", "e");
        put("\u1EF8", "Y");
        put("\u1EF9", "y");
        put("\u01CD", "A");
        put("\u01CE", "a");
        put("\u01CF", "I");
        put("\u01D0", "i");
        put("\u01D1", "O");
        put("\u01D2", "o");
        put("\u01D3", "U");
        put("\u01D4", "u");
        put("\u0232", "Y");
        put("\u0233", "y");
        put("\u01EA", "O");
        put("\u01EB", "o");
        put("\u1E0C", "D");
        put("\u1E0D", "d");
        put("\u1E24", "H");
        put("\u1E25", "h");
        put("\u1E36", "L");
        put("\u1E37", "l");
        put("\u1E38", "L");
        put("\u1E39", "l");
        put("\u1E42", "M");
        put("\u1E43", "m");
        put("\u1E46", "N");
        put("\u1E47", "n");
        put("\u1E5A", "R");
        put("\u1E5B", "r");
        put("\u1E5C", "R");
        put("\u1E5D", "r");
        put("\u1E62", "S");
        put("\u1E63", "s");
        put("\u1E6C", "T");
        put("\u1E6D", "t");
        put("\u00CF", "I");

        put("\u008C", "AE"); // doesn't work?
        put("\u016E", "U");
        put("\u016F", "u");

        put("\u0178", "Y");
        put("\u00FE", ""); // thorn character

        // UNICODE_CHARS.put("\u0100", "");
    }

}
