﻿# Java-Subjects

This is a set of open source Java projects packaged as Eclipse projects used for studying various software patterns. Some projects may require the [m2e plug-in](http://www.eclipse.org/m2e/), [tycho](https://eclipse.org/tycho), and the [gradle plug-in](http://gradle.org/eclipse/).

## Project specific settings

### JHotDraw

You may need to add `tools.jar` to your local JVM in Eclipse. See http://stackoverflow.com/questions/10314904/no-com-sun-tools-javac-in-jdk7.

### Elastic Search

- Import using Gradle wizard.
- Must use Gradle 2.13.
- Must set the `JAVA_HOME` environmental variable. You can do so in the run configuration.

### Spring Framework

Some spring components use Groovy. Although you may get it to compile on the command line, you may have trouble getting it to compile inside of Eclipse. To fix this problem, you'll need to install [groovy-eclipse](http://github.com/groovy/groovy-eclipse) using the associated [Eclipse update sites](https://github.com/groovy/groovy-eclipse/wiki#snapshot-builds).

The Eclipse metadata for Spring is not stored. As such, you will need to import the project as a gradle project into Eclipse. It may help to build the project on the command line if you run into trouble and then refresh the project in Eclipse.

### Azureus

If you get a build problem regarding SWT, see [this post](https://stackoverflow.com/questions/4498018/eclipse-plugin-dependency-on-swt-classes-not-being-resolved#answer-47186094). I've added jars for linux in [this commit](https://github.com/ponder-lab/Java-Subjects/commit/d7a02a2a2ef75d9fa2edb014e3df097f438c9888). If you aren't runninng linux (particularly Ubuntu), feel free to remove these from the build path and add your own.

### Soot

Although Eclipse metadata is present, the project should be imported as an existing maven project.

### Retrolambda

1. `JAVA_HOME` environemental varaible must be set.
1. Additionally, `JAVA7_HOME`, `JAVA6_HOME`, and `JAVA5_HOME` variables must be set as well. They can have the same value as `JAVA_HOME`, if desired/appropriate for building.
1. The maven `toolchains.xml` file must exist. If you don't have one, copy the one if the project directory to `$HOME/.m2`.
1. Edit the `$HOME/.m2/toolchains.xml` file to contain the appropriate JDK/JRE locations.

### jOOQ

Run the `build.sh` script in the project directory.

## Subject Descriptions

| Subject | Version | Description |
|---|---|--|
| [Art of Illusion](http://www.artofillusion.org) | | Art of Illusion is a free, open source 3D modeller renderer and raytracer. It is written in Java and runs on Linux, Solaris, OS X, and Windows. |
| [Azureus](http://www.vuze.com) | | Now known as Vuze, is a BitTorrent client used to transfer files via the BitTorrent protocol. |
| [Colt](http://dst.lbl.gov/ACSSoftware/colt/) | | Colt provides a set of Open Source Libraries for High Performance Scientific and Technical Computing in Java.|
| [Elasticsearch](https://www.elastic.co/products/elasticsearch) | | A Distributed RESTful Search Engine. |
| [Eclipse Collections](https://github.com/eclipse/eclipse-collections) | | A collections framework for Java. |
| [Guava](https://github.com/google/guava) | | Google Core Libraries for Java 6+. |
| [JDepend](http://clarkware.com/software/JDepend.html) | | JDepend traverses Java class and source file directories and generates design quality metrics for each Java package. |
| [JFlex](http://jflex.de) | | JFlex is a lexical analyzer generator (or scanner generator) for Java, written in Java.|
| [JGraph](https://www.jgraph.com) | | (Now called JGraphX) is a Java Swing diagramming (graph visualisation) library. It provides functionality for visualisation and interaction with node-edge graphs (not charts). |
| [JHotDraw](http://www.jhotdraw.org) | | An open-source Java GUI framework for technical and structured Graphics. |
| [JUnit](http://junit.org) | | A simple framework to write repeatable tests. |
| [Java8](http://www.oracle.com/technetwork/java/javase/overview/java8-2100321.html) | | A revolutionary release of the world’s #1 development platform. It includes a huge upgrade to the Java programming model and a coordinated evolution of the JVM, Java language, and libraries. |
| [JavaCup](http://www2.cs.tum.edu/projects/cup/) | | A parser generator that produces a parser written in Java. |
| [JavaODBAdapter](https://github.com/devesion/java-obd-adapter) | | OBD-II Java Adapter API. |
| [JavaPushFramework](http://www.pushframework.com) | | A Java version of Push Framework (A C++ library aimed at easing the development of high performance servers). |
| [RNAHeliCesGui](http://varna.lri.fr) | | RNAHeliCesGui is a basic editor that demonstrates the features of VARNA - an opensource, lightweight Java Applet dedicated to drawing the secondary structure of RNA. |
| [Tomcat](http://tomcat.apache.org) | | An open source software implementation of the Java Servlet, JavaServer Pages, Java Expression Language and Java WebSocket technologies. |
| [Verbos]() | | A free translating dictionary. |
| [VietPad](http://vietpad.sourceforge.net) | | A full-featured Java/.NET Vietnamese Unicode text editor. |
| [VioletUMLEditor](http://alexdp.free.fr/violetumleditor/page.php) | | Violet is a UML editor intended for developers, students, teachers, and authors who need to produce simple UML diagrams quickly. |
| [Weezle](http://couchware.ca/www/wezzle/) | | Wezzle is a game of quick reflexes and chain reaction. It's a game of zoomin' rockets and 'splody bombs, a game of singing stars and gravity wells. |
| [Zkoss](https://www.zkoss.org) | | ZK is an open-source Ajax Web application framework, written in Java, that enables creation of graphical user interfaces for Web applications with little required programming knowledge. |
| [Dari](http://www.dariframework.org) | | Dari is a powerful data modeling framework that makes it easy to work with complex data structures and persist them to one or more database backends. 
| [fractal](http://fractalfoundation.org/resources/fractal-software/) | | A Real-Time Zoomer feature that allows users to explore the Mandelbrot set and 23 other fractals. |
| [mwdumper](https://www.mediawiki.org/wiki/Manual:MWDumper#Where_to_find_it) | | A tool written in Java for extracting sets of pages from a MediaWiki dump file. |
| [osgi-desktop](http://www.knopflerfish.org/desktop.html) | | Displays a graphical overview of the OSGi framework. |
| [rdp4j](https://github.com/drapostolos/rdp4j) | | Remote Directory Poller for Java. |
| [sablecc](http://www.sablecc.org) | | A parser generator which generates fully featured object-oriented frameworks for building compilers, interpreters and other text parsers. |
| [spring-framework](http://spring.io) | | An application framework and inversion of control container for the Java platform.|
| [JabRef](http://www.jabref.org/) | | An open source bibliography reference manager.|
| [htm.java](https://github.com/numenta/htm.java) | 0.6.13 | Hierarchical Temporal Memory implementation in Java - an official Community-Driven Java port of the Numenta Platform for Intelligent Computing (NuPIC).|
| [jdk8-experiments](https://github.com/edalorzo/jdk8-experiments) | | An personal repository for experimentation with the new JDK 8 features.|
| [streamalg](https://github.com/biboudis/streamalg) | ecoop15-artifact | Extensible stream pipelines with object algebras. |
| [streamql](https://github.com/deephacks/streamql) | 0.5.8 | A query tool for `java.util.stream.Stream`. |
| [jOOQ](https://github.com/jOOQ/jOOQ) | 3.10.4 | jOOQ is the best way to write SQL in Java. |
| [bootique](https://github.com/bootique/bootique) | 0.17 | Bootique is a minimally opinionated platform for modern runnable Java apps. |
| [JacpFX](https://github.com/JacpFX/JacpFX) | 2.1 | An API to create Rich Clients in MVC style with JavaFX, Spring (or other DI frameworks) and an Actor like component approach. |
| [ThreeTen Extra](https://github.com/ThreeTen/threeten-extra) | 1.3.2 | Provide additional date-time classes that complement those in JDK 8. |
| [cryptomator](https://github.com/cryptomator/cryptomator) | 1.3.3 | Multi-platform transparent client-side encryption of your files in the cloud. |
| [jetty.project](https://github.com/eclipse/jetty.project) | 9.4.8 | Eclipse Jetty - Web Container & Clients - supports HTTP/2, HTTP/1.1, HTTP/1.0, websocket, servlets, and more. |
| [junit5](https://github.com/junit-team/junit5) | 5.0.2 | A unit testing framework for the Java programming language. |
| [koral](https://github.com/criscris/koral) | | Scientific publishing with HTML. |
| [masteringlambdas](https://github.com/mauricen/masteringlambdas) | | Examples from the "Mastering Lambdas" book. |
| [monads](https://github.com/RutledgePaulV/monads) | 0.5 | Basic monads for Java. |
| [retrolambda](https://github.com/orfjackal/retrolambda) | 2.5.3 | Backport of Java 8's lambda expressions to Java 7, 6 and 5. |
| [soot](https://github.com/Sable/soot) | [dcf86b5](https://github.com/Sable/soot/commit/dcf86b5045c54a02b1d627200bbb4544ba2aa21e) | A Java optimization framework. |
| [spring-data-jdbc](https://github.com/aiurio/spring-data-jdbc) | |
| [java-design-patterns](https://github.com/iluwatar/java-design-patterns) | 1.12.0 ([bc94d0f](https://github.com/iluwatar/java-design-patterns/commit/bc94d0fc26688a20480851f5c974f46396179a92)) | Design patterns implemented in Java. |
