//* @(#)Answer.java  1  2005
//Orginal code by Ho Ngoc Duc <duc@informatik.uni-leipzig.de>
//Modified by Ric Bottomley
//All rights reserved. 
//This material is provided "as is", with absolutely no warranty expressed
//or implied. Any use is at your own risk.
//Permission to use or copy this software is hereby granted without fee,
//provided this copyright notice is retained on all copies.

//implementation of a single answer
//A request to the IEngine object is encapsulated in an IRequest object
//an array of answers is returned from the iengine
//various methods unused but left in case of future modifications

package dict;

public class Answer implements IAnswer {
	IDatabase fDatabase;
	int fPosition;
	String fKey;
	String fDefinition;
	IWordList fMatches;
	IWordList adjacentWords;
	boolean usedMorph = false;
	
        public Answer(IDatabase db, String key, int pos, String def, boolean morph) {
		fDatabase = db;
		fKey = key;
		fPosition = pos;
		fDefinition = def;
		usedMorph = morph;
//fMatches = new WordList();
		//adjacentWords = new WordList();
	}
	
	public IDatabase getDatabase() {
		return fDatabase;
	}
	
	public String getDefinition() {
		return fDefinition;
	}
	
	public boolean usedMorph() {
                return usedMorph;
        }
        
        public java.lang.String getKey() {
		return fKey;
	}
	public IWordList getMatches() {
		return fMatches;
	}
	
	public int getPosition() {
		return fPosition;
	}
	public void setMatches(IWordList arr) {
		fMatches = arr;
	}
	public IWordList getAdjacentWords() {
		return adjacentWords;
	}
	public void setAdjacentWords(IWordList ls) {
		adjacentWords = ls;
	}
	public void setDatabase(IDatabase db) {
		fDatabase = db;
	}
	
        public void setDefinition(String def) {
            fDefinition = def;
	}
	public void setKey(String k) {
		fKey = k;
	}
}
