//* @(#)databaseFactory.java  1  2005
//Orginal code by Ho Ngoc Duc <duc@informatik.uni-leipzig.de>
//Modified by Ric Bottomley
//All rights reserved. 
//This material is provided "as is", with absolutely no warranty expressed
//or implied. Any use is at your own risk.
//Permission to use or copy this software is hereby granted without fee,
//provided this copyright notice is retained on all copies.


package dict;

//import org.dict.kernel.*;

import java.io.*;
/**
 * <p>To sort the index file: java org.dict.server.DatabaseFactory indexFile
 *
 * <p>Format of the ini file:
 * <pre>
	# Configuration for ev
	ev.data=anhviet.txt
	ev.index=anhviet.idx
	ev.memoryIndex=true
	ev.comparator=org.dict.vietdict.KeyComparator
	ev.name=English-Vietnamese
	# Configuration for ve
	ve.data=vietanh.txt
	ve.index=vietanh.idx
	ve.memoryIndex=true
	ve.comparator=org.dict.vietdict.KeyComparator
	ev.name=Vietnamese-English
 * </pre>
 */

//use this class as main, runDis uneccaary, load in the conf here
//this class creates idictengine

public class DatabaseFactory {
	static java.util.Hashtable fInstances = new java.util.Hashtable();

        /**
 * DatabaseFactory constructor comment.
 */
public DatabaseFactory(String cfg) {
super();

}
public static void addDatabases(IDictEngine eng, String cfg) {
	File f = new File(cfg);
	if (!f.exists()) {
		return;
	}
	//log(new java.util.Date().toString());
	//Create dictionary engine using configuration " +cfg
	DatabaseConfiguration[] configs = DatabaseConfiguration.readConfiguration(cfg);
	for (int i = 0; i<configs.length; i++){
		try {
			eng.addDatabase(Database.createDatabase(configs[i]));
		} catch (Throwable e) {e.printStackTrace();}
	}
	//Databases created!
}
public static void dbSort(String in, IComparator c) {
    //System.out.println("dbsort called " + in);
    
    int last = in.lastIndexOf('.');
	String base = in;
	if (last > 0) {
		base = in.substring(0, last);
	}
	String tmp = base+".tmp";
	String bak = base+".bak";
	//System.out.println("Sort file "+in+" and copy original file to "+bak);
	try {
		KeyList kl = new MemoryKeyList(in);
		IKey[] arr = new IKey[kl.size()];
		for (int i = 0; i < arr.length; i++){
			arr[i] = (IKey) kl.get(i);
		}
		ListUtil.sort(arr, c);
		BufferedOutputStream w = new BufferedOutputStream(new FileOutputStream(tmp));
		for (int i = 0; i < arr.length; i++){
			w.write((arr[i].getKey()+"\t"+arr[i].getOffset()+"\t"+arr[i].getLength()).getBytes(kl.getEncoding()));
			if (i<arr.length-1) { w.write('\n');}
		}
		w.flush();
		w.close();
		System.out.println("File sorted. Rename original file to "+bak);
		File old = new File(bak);
		if (old.exists()) {
			old.delete();
		}
		new File(in).renameTo(old);
		System.out.println("Rename temp file to "+in);
		File f = new File(tmp);
		try {
			boolean ret = f.renameTo(new File(in));
			if (!ret) {
				System.out.println("Cannot rename. Please copy file "+tmp+" to "+in);
			}
		} catch (Exception e) {
			System.out.println("Please copy file "+tmp+" to "+in);
			return;
		}
		if (f.exists()) {
			System.out.println("Delete temp file");
			try {
				f.delete();
			} catch (Exception e) {
				System.out.println("Could not remove temp file "+tmp);
			}
		}
		System.out.println("Done!");
	} catch (Throwable t) {
		t.printStackTrace();
	}
}

//create idictengine or return it if created, stores engine with config in hash table
//when this method return engine everything is ready and configured
public static IDictEngine getEngine(String cfg) {
	String s = new File(cfg).getAbsolutePath().toLowerCase();
	//finstances is a hash table
        //finstances holds the database with its config
        //returns the value to which the config is mapped
        IDictEngine ret = (IDictEngine) fInstances.get(s);
	
        if (ret == null) {
		ret = new DictEngine();
		addDatabases(ret, cfg);
		fInstances.put(s, ret);
	}
	return ret;
}

//static void log(String msg) {
	//Logger.getInstance().log(msg);
//}
/**
 * 
 * @param args java.lang.String[]
 */

//method to sort out indexes
public static void sort(String f){
    IComparator c = new KeyComparator();
    dbSort(f, c);
}

/*
public static void main(String[] args) {

 if (args.length != 2) {
		System.out.println("Usage: java "+DatabaseFactory.class.getName()+" iniFile dbID");
		System.exit(0);
	}
	File f = new File(args[0]);
	java.util.Properties p = new java.util.Properties();
	try {
		InputStream in = new FileInputStream(f);
		p.load(in);
		in.close();
	} catch (Throwable t) {
            
            t.printStackTrace();
	}
	String id = args[1];
	String indexFile = (String) p.get(id+".index");
        String enc = p.getProperty(id + ".encoding", "utf-8");
	IComparator c = new KeyComparator();
	String comp = p.getProperty(id + ".comparator");
	if (comp != null) {
		try {
			c = (IComparator) Class.forName(comp).newInstance();
		} catch (Throwable e) {
		}
	}
	//IComparator c = new KeyComparator();
        //dbSort(indexFile, c);


//create new idictengine by passing database factory the config
        IDictEngine e = DatabaseFactory.getEngine(args[0]); 
        //now lets get the databases we have
        //and prove we know whats going on by sending a query and printing the answer
       
//  db=dbID&word=headword or db=ibID&pos=N. Create an IRequest
      //   object and pass it to the lookup method 
// can only have pos or word
//  

//simple change db=se+word to db=es+word for language changes
        IRequest req = new SimpleRequest("db=se&word=tener");    
// requestURI is what is returned if we fancy and cud be a path to a cgi script
IAnswer[] arr = e.lookup(req);        
for (int i=0;i<arr.length;i++) {
Answer anAnswer = (Answer) arr[i];
System.out.println(anAnswer.getDefinition());
System.out.println(anAnswer.getKey());




}

}
*/

}
