//* @(#)FlatDataAccessor.java  1  2005
//Orginal code by Ho Ngoc Duc <duc@informatik.uni-leipzig.de>
//Modified by Ric Bottomley
//All rights reserved. 
//This material is provided "as is", with absolutely no warranty expressed
//or implied. Any use is at your own risk.
//Permission to use or copy this software is hereby granted without fee,
//provided this copyright notice is retained on all copies.


package dict;

import java.io.*;
/**
 * Insert the type's description here.
 * Creation date: (28.07.01 22:45:52)
 * @author: Administrator
 */
public class FlatDataAccessor implements IDataAccessor {
	String fDatafile;
/**
 * FlatDatabase constructor comment.
 */
public FlatDataAccessor(String fileName) {
	super();
	fDatafile = fileName;
}

public String getDatafile() {
	return fDatafile;
}

/**
 * readData method comment.
 */
public byte[] readData(long pos, long len) throws IOException {
	java.io.RandomAccessFile f = null;
	byte[] buf = new byte[(int)len];
	try {
		f = new java.io.RandomAccessFile(getDatafile(), "r");
		f.seek(pos);
		f.readFully(buf);
		return buf;
	} catch (IOException e) {
		throw e;
	} finally {
		if (f != null) {
			f.close();
			f = null;
		}
	}
}
}
