//* @(#)IDataBase.java  1  2005
//Orginal code by Ho Ngoc Duc <duc@informatik.uni-leipzig.de>
//Modified by Ric Bottomley
//All rights reserved. 
//This material is provided "as is", with absolutely no warranty expressed
//or implied. Any use is at your own risk.
//Permission to use or copy this software is hereby granted without fee,
//provided this copyright notice is retained on all copies.

package dict;
import java.io.File;
//this class is basically for a single database
public interface IDatabase {
	public static final int STRATEGY_NONE = -1; // Dont look for matches
	public static final int STRATEGY_EXACT = 0;
	public static final int STRATEGY_PREFIX = 1;
	public static final int STRATEGY_SUBSTRING = 2;
	public static final int STRATEGY_SUFFIX = 3;
	/**
	 * This command will look up the specified word in the database
	 */
	String define(String word);
	/**
	 * This command will look up the word with specified index in the database
	 */
	
        IAnswer defineMatch(int pos, boolean define, int strategy);
	/**
	 * This command will look up the specified word in the database
	 */
//rix the 3 below	
IAnswer defineMatch(String word, boolean define, int strategy);

	/**
	 * Show the database info
	 */
	String getDescription();
	/**
	 * Show the database info
	 */
	String getID();
	/**
	 * Show the database info
	 */
	String getName();
	/**
	 * Return the position of a key in the database
	 */
	
        //returns the index file associated with the db
        File getIndexFile();
        //rerurn the locale collater
        String getCollate();
        
        int getPosition(String key);

	/**
	 * This command searches an index for the dictionary, and reports words
	 * which were found using a particular strategy, together with their positions.
	 */
 //rix
IWordList match(String word, int strategy);
	
	/**
	 * Get the key together with its position
	 */
//rix	
IWordPosition getKey(int pos);
	
	/**
	 * Get the number of entries in the database
	 * @author Administrator
	 * 10.03.2004
	 */
	int getSize();
}
